/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.CryptoPermission;
import javax.crypto.CryptoPolicyParser;
import javax.crypto.PermissionsEnumerator;

final class CryptoPermissions
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 4946547168093391015L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", Hashtable.class)};
    private transient ConcurrentHashMap<String, PermissionCollection> perms = new ConcurrentHashMap(7);

    CryptoPermissions() {
    }

    void load(InputStream inputStream) throws IOException, CryptoPolicyParser.ParsingException {
        CryptoPolicyParser cryptoPolicyParser = new CryptoPolicyParser();
        cryptoPolicyParser.read(new BufferedReader(new InputStreamReader(inputStream, "UTF-8")));
        CryptoPermission[] cryptoPermissionArray = cryptoPolicyParser.getPermissions();
        for (int i = 0; i < cryptoPermissionArray.length; ++i) {
            this.add(cryptoPermissionArray[i]);
        }
    }

    boolean isEmpty() {
        return this.perms.isEmpty();
    }

    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("Attempt to add a Permission to a readonly CryptoPermissions object");
        }
        if (!(permission instanceof CryptoPermission)) {
            return;
        }
        CryptoPermission cryptoPermission = (CryptoPermission)permission;
        PermissionCollection permissionCollection = this.getPermissionCollection(cryptoPermission);
        permissionCollection.add(cryptoPermission);
        String string = cryptoPermission.getAlgorithm();
        this.perms.putIfAbsent(string, permissionCollection);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof CryptoPermission)) {
            return false;
        }
        CryptoPermission cryptoPermission = (CryptoPermission)permission;
        PermissionCollection permissionCollection = this.getPermissionCollection(cryptoPermission.getAlgorithm());
        return permissionCollection.implies(cryptoPermission);
    }

    @Override
    public Enumeration<Permission> elements() {
        return new PermissionsEnumerator(this.perms.elements());
    }

    CryptoPermissions getMinimum(CryptoPermissions cryptoPermissions) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (cryptoPermissions == null) {
            return null;
        }
        if (this.perms.containsKey("CryptoAllPermission")) {
            return cryptoPermissions;
        }
        if (cryptoPermissions.perms.containsKey("CryptoAllPermission")) {
            return this;
        }
        CryptoPermissions cryptoPermissions2 = new CryptoPermissions();
        PermissionCollection permissionCollection = cryptoPermissions.perms.get("*");
        int n = 0;
        if (permissionCollection != null) {
            n = ((CryptoPermission)permissionCollection.elements().nextElement()).getMaxKeySize();
        }
        Enumeration<String> enumeration = this.perms.keys();
        while (enumeration.hasMoreElements()) {
            object4 = enumeration.nextElement();
            object3 = this.perms.get(object4);
            object2 = cryptoPermissions.perms.get(object4);
            if (object2 == null) {
                if (permissionCollection == null) continue;
                object = this.getMinimum(n, (PermissionCollection)object3);
            } else {
                object = this.getMinimum((PermissionCollection)object3, (PermissionCollection)object2);
            }
            for (int i = 0; i < ((CryptoPermission[])object).length; ++i) {
                cryptoPermissions2.add(object[i]);
            }
        }
        object4 = this.perms.get("*");
        if (object4 == null) {
            return cryptoPermissions2;
        }
        n = ((CryptoPermission)((PermissionCollection)object4).elements().nextElement()).getMaxKeySize();
        object3 = cryptoPermissions.perms.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (this.perms.containsKey(object2)) continue;
            object = cryptoPermissions.perms.get(object2);
            CryptoPermission[] cryptoPermissionArray = this.getMinimum(n, (PermissionCollection)object);
            for (int i = 0; i < cryptoPermissionArray.length; ++i) {
                cryptoPermissions2.add(cryptoPermissionArray[i]);
            }
        }
        return cryptoPermissions2;
    }

    private CryptoPermission[] getMinimum(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>(2);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        block0: while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            Enumeration<Permission> enumeration2 = permissionCollection2.elements();
            while (enumeration2.hasMoreElements()) {
                CryptoPermission cryptoPermission = (CryptoPermission)enumeration2.nextElement();
                if (cryptoPermission.implies((Permission)objectArray)) {
                    vector.addElement(objectArray);
                    continue block0;
                }
                if (!objectArray.implies(cryptoPermission)) continue;
                vector.addElement(cryptoPermission);
            }
        }
        objectArray = new CryptoPermission[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private CryptoPermission[] getMinimum(int n, PermissionCollection permissionCollection) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>(1);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (objectArray.getMaxKeySize() <= n) {
                vector.addElement(objectArray);
                continue;
            }
            if (objectArray.getCheckParam()) {
                vector.addElement(new CryptoPermission(objectArray.getAlgorithm(), n, objectArray.getAlgorithmParameterSpec(), objectArray.getExemptionMechanism()));
                continue;
            }
            vector.addElement(new CryptoPermission(objectArray.getAlgorithm(), n, objectArray.getExemptionMechanism()));
        }
        objectArray = new CryptoPermission[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    PermissionCollection getPermissionCollection(String string) {
        PermissionCollection permissionCollection = this.perms.get("CryptoAllPermission");
        if (permissionCollection == null && (permissionCollection = this.perms.get(string)) == null) {
            permissionCollection = this.perms.get("*");
        }
        return permissionCollection;
    }

    private PermissionCollection getPermissionCollection(CryptoPermission cryptoPermission) {
        String string = cryptoPermission.getAlgorithm();
        PermissionCollection permissionCollection = this.perms.get(string);
        if (permissionCollection == null) {
            permissionCollection = cryptoPermission.newPermissionCollection();
        }
        return permissionCollection;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("perms", null);
        this.perms = hashtable != null ? new ConcurrentHashMap(hashtable) : new ConcurrentHashMap();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, PermissionCollection> hashtable = new Hashtable<String, PermissionCollection>(this.perms);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("perms", hashtable);
        objectOutputStream.writeFields();
    }
}

