% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kalmanBucyFilter.R
\name{plot,yuima.kalmanBucyFilter,ANY-method}
\alias{plot,yuima.kalmanBucyFilter,ANY-method}
\title{Plotting Method for Kalman-Bucy Filter}
\usage{
\S4method{plot}{yuima.kalmanBucyFilter,ANY}(
  x,
  plot_truth = FALSE,
  level = 0,
  legend = TRUE,
  legend_position = "top",
  legend_cex = 1
)
}
\arguments{
\item{x}{A \code{\link{yuima.kalmanBucyFilter-class}} object.}

\item{plot_truth}{Logical. If \code{TRUE}, plot true values of state variables.}

\item{level}{Numeric. If 0 < \code{level} < 1, plot confidence interval of \code{level}.}

\item{legend}{Logical. If \code{TRUE}, a legend is added to the plot.}

\item{legend_position}{Character. Position of the legend, passed to 
\code{\link[graphics]{legend}} (e.g., \code{"topright"}, \code{"bottom"},
\code{"top"}, \code{"left"}, or \code{"none"}).}

\item{legend_cex}{Numeric. Scaling factor for the legend text size, 
corresponding to the \code{cex} argument in \code{\link[graphics]{legend}}.}
}
\value{
NULL (plot is drawn)
}
\description{
Plotting method for objects of class \code{yuima.kalmanBucyFilter}.
}
\details{
This method plots the estimated values of state variables by Kalman-Bucy filter. 
Optionally, it can plot true values of state variables which may exist when using simulated data.
Also, it can plot confidence interval of \code{level} if 0 < \code{level} < 1.
}
\examples{
\dontrun{
# create Kalman-Bucy filter object
drift <- c('a*X', 'c*X')
diffusion <- matrix(
  c('b', '0', '0', 'sigma'),
  2, 2
)
vars <- c('X', 'Y')
mod <- setModel(
  drift = drift, diffusion = diffusion, solve.variable = vars,
  state.variable = vars, observed.variable = 'Y', xinit = c(0, 0)
)
samp <- setSampling(delta = 0.01, n = 10^3)
trueparam <- list(a = -1.5, b = 0.3, c = 1, sigma = 0.02)

### simulate
yuima <- simulate(mod, sampling = samp, true.parameter = trueparam)
res <- kalmanBucyFilter(
  yuima,
  params = trueparam, mean_init = 0, vcov_init = 0.1,
  delta.vcov.solve = 0.001, are = FALSE
)

### visualize
plot(res, plot_truth = TRUE, level = 0.95)
}
}
\author{
The YUIMA Project Team
}
