% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConditionalCtreeSampler.R
\name{ConditionalCtreeSampler}
\alias{ConditionalCtreeSampler}
\title{(experimental) Conditional Inference Tree Conditional Sampler}
\description{
Implements conditional sampling using conditional inference trees (ctree).
Builds a tree predicting target features from conditioning features, then samples
from the terminal node corresponding to each test observation.
}
\details{
This sampler approximates the conditional distribution \eqn{P(X_B | X_A = x_A)} by:
\enumerate{
\item Building a conditional inference tree with \eqn{X_B} as response and \eqn{X_A} as predictors
\item For each test observation, finding its terminal (leaf) node in the tree
\item Sampling uniformly from training observations in that same terminal node
}

Conditional inference trees (ctree) use permutation tests to determine splits,
which helps avoid overfitting and handles mixed feature types naturally. The tree
partitions the feature space based on the conditioning variables, creating local
neighborhoods that respect the conditional distribution structure.

\strong{Key advantages over other samplers:}
\itemize{
\item Handles mixed feature types (continuous and categorical)
\item Non-parametric (no distributional assumptions)
\item Automatic feature selection (splits only on informative features)
\item Can capture non-linear conditional relationships
\item Statistically principled splitting criteria
}

\strong{Hyperparameters} control tree complexity:
\itemize{
\item \code{mincriterion}: Significance level for splits (higher = fewer splits)
\item \code{minsplit}: Minimum observations required for a split
\item \code{minbucket}: Minimum observations in terminal nodes
}

This implementation is inspired by shapr's ctree approach but simplified for our
use case (we build trees on-demand rather than pre-computing all subsets).

\strong{Advantages:}
\itemize{
\item Works with any feature types
\item Robust to outliers
\item Interpretable tree structure
\item Handles high-dimensional conditioning
}

\strong{Limitations:}
\itemize{
\item Requires model fitting (slower than kNN)
\item Can produce duplicates if terminal nodes are small
\item Tree building time increases with data size
}
}
\examples{
\donttest{
library(mlr3)
task = tgen("friedman1")$generate(n = 100)

# Create sampler with default parameters
sampler = ConditionalCtreeSampler$new(task)

# Sample features conditioned on others
test_data = task$data(rows = 1:5)
sampled = sampler$sample_newdata(
  feature = c("important2", "important3"),
  newdata = test_data,
  conditioning_set = "important1"
)
}

}
\references{
Hothorn T, Hornik K, Zeileis A (2006).
\dQuote{Unbiased Recursive Partitioning: A Conditional Inference Framework.}
\emph{Journal of Computational and Graphical Statistics}, \bold{15}(3), 651--674.
\doi{10.1198/106186006X133933}.

Aas K, Jullum M, Løland A (2021).
\dQuote{Explaining Individual Predictions When Features Are Dependent: More Accurate Approximations to Shapley Values.}
\emph{Artificial Intelligence}, \bold{298}, 103502.
\doi{10.1016/j.artint.2021.103502}.
}
\section{Super classes}{
\code{\link[xplainfi:FeatureSampler]{xplainfi::FeatureSampler}} -> \code{\link[xplainfi:ConditionalSampler]{xplainfi::ConditionalSampler}} -> \code{ConditionalCtreeSampler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{feature_types}}{(\code{character()}) Feature types supported by the sampler.
Will be checked against the provided \link[mlr3:Task]{mlr3::Task} to ensure compatibility.}

\item{\code{tree_cache}}{(\code{environment}) Cache for fitted ctree models.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConditionalCtreeSampler-new}{\code{ConditionalCtreeSampler$new()}}
\item \href{#method-ConditionalCtreeSampler-clone}{\code{ConditionalCtreeSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="print"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-print'><code>xplainfi::FeatureSampler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="ConditionalSampler" data-id="sample"><a href='../../xplainfi/html/ConditionalSampler.html#method-ConditionalSampler-sample'><code>xplainfi::ConditionalSampler$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="ConditionalSampler" data-id="sample_newdata"><a href='../../xplainfi/html/ConditionalSampler.html#method-ConditionalSampler-sample_newdata'><code>xplainfi::ConditionalSampler$sample_newdata()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalCtreeSampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalCtreeSampler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new ConditionalCtreeSampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalCtreeSampler$new(
  task,
  conditioning_set = NULL,
  mincriterion = 0.95,
  minsplit = 20L,
  minbucket = 7L,
  use_cache = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task}) Task to sample from.}

\item{\code{conditioning_set}}{(\code{character} | \code{NULL}) Default conditioning set to use in \verb{$sample()}.}

\item{\code{mincriterion}}{(\code{numeric(1)}: \code{0.95}) Significance level threshold for splitting (1 - p-value).
Higher values result in fewer splits (simpler trees).}

\item{\code{minsplit}}{(\code{integer(1)}: \code{20L}) Minimum number of observations required for a split.}

\item{\code{minbucket}}{(\code{integer(1)}: \code{7L}) Minimum number of observations in terminal nodes.}

\item{\code{use_cache}}{(\code{logical(1)}: \code{TRUE}) Whether to cache fitted trees.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalCtreeSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalCtreeSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalCtreeSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
