% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmw_pvalue.R
\name{wmw_pvalue}
\alias{wmw_pvalue}
\title{P-value for Wilcoxon-Mann-Whitney Test of No Group Discrimination (Continuous Variables)}
\usage{
wmw_pvalue(x, y, alternative = "two.sided")
}
\arguments{
\item{x}{Numeric vector of cases/group 1 values}

\item{y}{Numeric vector of controls/reference group values}

\item{alternative}{character: "two.sided", "greater", or "less"}
}
\value{
p-value
}
\description{
Tests \eqn{\mathrm{H_0\colon AUC} = 0.5}{AUC = 0.5} vs \eqn{\mathrm{H_1\colon AUC} \neq 0.5}{AUC != 0.5}
with proper finite-sample corrections
}
\details{
Implements the Bias-Corrected (BC) variance estimator with second-order
U-statistic correction to provide honest p-values under \eqn{\mathrm{H_0\colon AUC} = 0.5}{H₀: AUC = 0.5}.
Uses three-tier approach: permutation \eqn{(n < 20)}{(n < 20)},
bias-corrected \eqn{(20 \le n < 50)}{(20 <= n < 50)},
asymptotic with correction \eqn{n \ge 50}{(n >= 50)}.

For medium samples, the naive variance estimators \eqn{\widehat{\mathrm{Var}}(G(X))}{Var̂(G(X))} 
and \eqn{\widehat{\mathrm{Var}}(F(Y))}{Var̂(F(Y))} are
corrected by subtracting O(1/n) bias terms of the form
\eqn{(n_1 n_2)^{-1} \sum_i \hat{G}(X_i)(1 - \hat{G}(X_i))}
to prevent variance underestimation that would inflate Type I error rates.

Function assumes \eqn{x} represents cases and \eqn{y} represents the reference level,
in accord with \code{wilcox.test()} and \code{wmw_test()}.
Internal calculations convert to P(X < Y) framework to match theoretical derivations.
}
