% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk.R
\name{wk_chunk_strategy_single}
\alias{wk_chunk_strategy_single}
\alias{wk_chunk_strategy_feature}
\alias{wk_chunk_strategy_coordinates}
\title{Chunking strategies}
\usage{
wk_chunk_strategy_single()

wk_chunk_strategy_feature(n_chunks = NULL, chunk_size = NULL)

wk_chunk_strategy_coordinates(n_chunks = NULL, chunk_size = NULL, reduce = "*")
}
\arguments{
\item{n_chunks, chunk_size}{Exactly one of the number of
chunks or the chunk size. For \code{\link[=wk_chunk_strategy_feature]{wk_chunk_strategy_feature()}}
the chunk size refers to the number of features; for
\code{\link[=wk_chunk_strategy_coordinates]{wk_chunk_strategy_coordinates()}} this refers to the number
of coordinates as calculated from multiple handleables
using \code{reduce}.}

\item{reduce}{For \code{\link[=wk_chunk_strategy_coordinates]{wk_chunk_strategy_coordinates()}} this refers to
the function used with \code{\link[=Reduce]{Reduce()}} to combine coordinate counts
from more than one handleable.}
}
\value{
A function that returns a \code{data.frame} with columns \code{from} and \code{to}
when called with a \code{handleable} and the feature count.
}
\description{
It is often impractical, inefficient, or impossible to perform
an operation on a vector of geometries with all the geometries loaded
into memory at the same time. These functions help generalize the
pattern of split-apply-combine to one or more handlers recycled along a
common length. These functions are designed for developers rather than users
and should be considered experimental.
}
\examples{
feat <- c(as_wkt(xy(1:4, 1:4)), wkt("LINESTRING (1 1, 2 2)"))
wk_chunk_strategy_single()(list(feat), 5)
wk_chunk_strategy_feature(chunk_size = 2)(list(feat), 5)
wk_chunk_strategy_coordinates(chunk_size = 2)(list(feat), 5)

}
