% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.Kappa.R
\name{print.Kappa}
\alias{print.Kappa}
\title{Print Kappa}
\usage{
\method{print}{Kappa}(
  x,
  digits = max(getOption("digits") - 3, 3),
  CI = FALSE,
  level = 0.95,
  ...
)
}
\arguments{
\item{x}{A Kappa object}

\item{digits}{number of digits to print}

\item{CI}{Include confidence intervals in the display?}

\item{level}{confidence level}

\item{\dots}{Other arguments}
}
\value{
Returns the Kappa object, invisibly.
}
\description{
This is a replacement for the \code{print.Kappa} method in \code{vcd},
adding display of \code{z} values to the \code{vcd} version and optional
confidence intervals.
}
\examples{

data("SexualFun")
Kappa(SexualFun)
print(Kappa(SexualFun), CI=TRUE)

# stratified 3-way table
apply(MSPatients, 3, Kappa)

}
\seealso{
\code{\link[vcd]{confint.Kappa}}
}
\author{
Michael Friendly
}
\keyword{category}
\keyword{htest}
