% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{summarize_cv_results}
\alias{summarize_cv_results}
\title{Summarize Rolling Window Results}
\usage{
summarize_cv_results(cv_results, bootstrap_reps = 300L)
}
\arguments{
\item{cv_results}{Data frame from rolling_window_cv.}

\item{bootstrap_reps}{Number of bootstrap replications. Default 300.}
}
\value{
A data frame with summary statistics by model and partition.
}
\description{
Computes summary statistics from rolling window cross-validation.
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2029, 5),
    sector = rep(LETTERS[1:5], each = 30),
    log_direct = rnorm(150, 5, 0.5),
    log_production = rnorm(150, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(150, 0, 0.1)

  cv_results <- rolling_window_cv(panel, window_sizes = c(15, 20))
  summary_stats <- summarize_cv_results(cv_results)
  print(summary_stats)
}
}

}
