% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainUCDP.R
\name{runcertainUCDP}
\alias{runcertainUCDP}
\alias{puncertainUCDP}
\alias{duncertainUCDP}
\alias{quncertainUCDP}
\title{Parametric uncertainty distributions for UCDP events}
\usage{
runcertainUCDP(n, fatalities, tov = c("sb", "ns", "os", "any"))

puncertainUCDP(q, fatalities, tov = c("sb", "ns", "os", "any"))

duncertainUCDP(x, fatalities, tov = c("sb", "ns", "os", "any"))

quncertainUCDP(p, fatalities, tov = c("sb", "ns", "os", "any"))
}
\arguments{
\item{n}{Number of observations to generate random values for}

\item{fatalities}{A vector of non-negative integers representing the number of fatalities of the UCDP events. Non-integer values are allowed but should be considered experimental.}

\item{tov}{A character string representing the type of violence of the UCDP. Must be one of "sb", "ns", "os", or "any". The options are:

* "sb" for state-based violence
* "ns" for non-state violence
* "os" for one-sided violence
* "any" for parameters estimated across all type of violence. This is somewhat experimental and should be used with caution. This is possibly useful when the type of violence is unknown or when the user wants to combine all types of violence into a single category.}

\item{x, q}{Vector of quantiles}

\item{p}{Vector of probabilities}
}
\value{
* \code{duncertainUCDP} gives the density function
* \code{puncertainUCDP} gives the distribution function
* \code{quncertainUCDP} gives the quantile function
* \code{runcertainUCDP} generates random values as a vector of length \code{n}
}
\description{
Density, distribution, quantile and random number generation functions for the parametric reported-value inflated Gumbel mixture distribution for UCDP events. The functions estimate the parameters of the distribution based on the number of fatalities and the type of violence of the UCDP event.
}
\details{
The reported-value inflated Gumbel mixture distribution is a parametric distribution for modeling the uncertainty in the number of fatalities of UCDP events. The distribution is a mixture of a Gumbel distribution and a point mass at the reported number of fatalities. The distribution is estimated based on the number of fatalities and the type of violence of the UCDP event. The distribution is estimated using a set of regression models that estimate the location, scale, and weight parameters of the distribution based on the number of fatalities and the type of violence of the UCDP event.
}
\examples{

data(ucdpged)

# Generate 10 random values for an arbitrary UCDP event
runcertainUCDP(n = 10, fatalities = 100, tov = 'sb')

# Generate 10 random values for the first event in the GED sample
runcertainUCDP(n = 10, fatalities = ucdpged$best[1], tov = ucdpged$type_of_violence[1])

# Obtaining the probability that an arbitrary UCDP event has at least 150 fatalities
puncertainUCDP(q = 150, fatalities = 100, tov = 'ns')

# Obtaining the probability that the for the first event in the GED sample has at least 5 fatalities
puncertainUCDP(q = 5, fatalities = ucdpged$best[1], tov = ucdpged$type_of_violence[1])

# Obtaining the 90th percentile for an arbitrary UCDP event and one-sided violence
quncertainUCDP(p = 0.9, fatalities = 100, tov = 'os')

# Obtaining the 90th percentile for the first event in the GED sample
quncertainUCDP(p = 0.9, fatalities = ucdpged$best[1], tov = ucdpged$type_of_violence[1])

# Obtaining the density for an arbitrary UCDP event and state-based violence
duncertainUCDP(x = seq(from = 0, to = 500), fatalities = 100, tov = 'sb')

# Obtaining the density for the first event in the GED sample
duncertainUCDP(x = seq(0, 50), fatalities = ucdpged$best[1], tov = ucdpged$type_of_violence[1])

}
