% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_style.R
\name{tt_style}
\alias{tt_style}
\title{Style overall table appearance}
\usage{
tt_style(
  table,
  stroke = NULL,
  fill = NULL,
  striped = NULL,
  inset = NULL,
  row_gutter = NULL,
  column_gutter = NULL,
  position = NULL,
  full_width = FALSE
)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{stroke}{Stroke (border) specification: \code{TRUE} for default 1pt black borders,
a color name/hex for 1pt borders in that color, or a Typst stroke specification
like \code{"2pt + blue"}. When stroke is set, gap columns and separator lines from
\code{tt_header_above()} are automatically suppressed.}

\item{fill}{Fill color for the entire table.}

\item{striped}{Logical. If \code{TRUE}, alternates row background colors for readability.}

\item{inset}{Cell padding. Can be a single value (e.g., \code{"5pt"}) or named vector
for different padding on each side.}

\item{row_gutter}{Vertical spacing between rows.}

\item{column_gutter}{Horizontal spacing between columns.}

\item{position}{Table position on page: \code{"auto"}, \code{"left"}, \code{"center"}, \code{"right"}.}

\item{full_width}{Logical. If \code{TRUE}, table spans full page width.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Sets global styling properties for the entire table including stroke (borders),
fill, striped rows, and spacing.
}
\examples{
# Add borders and striped rows
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_style(stroke = TRUE, striped = TRUE)

# Custom border color and padding
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_style(stroke = "gray", inset = "8pt")

}
