% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_trends.R
\name{augment_trends}
\alias{augment_trends}
\title{Add trend columns to data frame}
\usage{
augment_trends(
  data,
  date_col = "date",
  value_col = "value",
  group_vars = NULL,
  methods = "stl",
  frequency = NULL,
  suffix = NULL,
  window = NULL,
  smoothing = NULL,
  band = NULL,
  align = NULL,
  params = list(),
  .quiet = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame}, \code{tibble}, or \code{data.table} containing the time series data.}

\item{date_col}{Name of the date column. Defaults to \code{"date"}.
Must be of class \code{Date}.}

\item{value_col}{Name of the value column. Defaults to \code{"value"}.
Must be \code{numeric}.}

\item{group_vars}{Optional grouping variables for multiple
time series. Can be a character vector of column names.}

\item{methods}{Character vector of trend methods.
Options: \code{"hp"}, \code{"bk"}, \code{"cf"}, \code{"ma"}, \code{"stl"}, \code{"loess"}, \code{"spline"}, \code{"poly"},
\code{"bn"}, \code{"ucm"}, \code{"hamilton"}, \code{"spencer"}, \code{"ewma"}, \code{"wma"},
\code{"triangular"}, \code{"kernel"}, \code{"kalman"}, \code{"median"}, \code{"gaussian"}.
Default is \code{"stl"}.}

\item{frequency}{The frequency of the series.
Supports 4 (quarterly) or 12 (monthly). Will be auto-detected if not specified.}

\item{suffix}{Optional suffix for trend column names.
If NULL, uses method names.}

\item{window}{Unified window/period parameter for moving
average methods (ma, wma, triangular, stl, ewma, median, gaussian). Must be positive.
If NULL, uses frequency-appropriate defaults. For EWMA, specifies the window
size when using TTR's optimized implementation. Cannot be used simultaneously
with \code{smoothing} for EWMA method.}

\item{smoothing}{Unified smoothing parameter for smoothing
methods (hp, loess, spline, ewma, kernel, kalman).
For hp: use large values (1600+) or small values (0-1) that get converted.
For EWMA: specifies the alpha parameter (0-1) for traditional exponential smoothing.
Cannot be used simultaneously with \code{window} for EWMA method.
For kernel: multiplier of optimal bandwidth (1.0 = optimal, <1 = less smooth, >1 = more smooth).
For kalman: controls the ratio of measurement to process noise (higher = more smoothing).
For others: typically 0-1 range.}

\item{band}{Unified band parameter for bandpass filters
(bk, cf). Both values must be positive.
Provide as \code{c(low, high)} where low/high are periods in quarters, e.g., \code{c(6, 32)}.}

\item{align}{Unified alignment parameter for moving average
methods (ma, wma, triangular, gaussian). Valid values: \code{"center"} (default, uses
surrounding values), \code{"right"} (causal, uses past values only), \code{"left"} (anti-causal,
uses future values only). Note: triangular only supports \code{"center"} and \code{"right"}.
If NULL, uses \code{"center"} as default.}

\item{params}{Optional list of method-specific parameters for fine control.}

\item{.quiet}{If \code{TRUE}, suppress informational messages.}
}
\value{
A tibble with original data plus trend columns named \verb{trend_\{method\}} or
\verb{trend_\{method\}_\{suffix\}} if suffix is provided.
}
\description{
Pipe-friendly function that adds trend columns to a tibble or data.frame.
Designed for exploratory analysis of monthly and quarterly economic time series.
Supports multiple trend extraction methods and handles grouped data.
}
\details{
This function is designed for monthly (frequency = 12) and quarterly (frequency = 4)
economic data. It uses economic-appropriate defaults for all trend extraction methods.

For grouped data, the function applies trend extraction to each group separately,
maintaining the original data structure while adding trend columns.
}
\examples{
# Simple STL decomposition on quarterly GDP construction data
gdp_construction |> augment_trends(value_col = "index")

# Multiple smoothing methods with unified parameter
gdp_construction |>
  augment_trends(
    value_col = "index",
    methods = c("hp", "loess", "ewma"),
    smoothing = 0.3
  )

# Moving averages with unified window on monthly data
vehicles |>
  tail(60) |>
  augment_trends(
    value_col = "production",
    methods = c("ma", "wma", "triangular"),
    window = 8
  )

# Economic indicators with different methods
ibcbr |>
  tail(48) |>
  augment_trends(
    value_col = "index",
    methods = c("median", "kalman", "kernel"),
    window = 9,
    smoothing = 0.15
  )

# Moving average with right alignment (causal filter)
vehicles |>
  tail(60) |>
  augment_trends(
    value_col = "production",
    methods = "ma",
    window = 12,
    align = "right"
  )

# Advanced: fine-tune specific methods
electric |>
  tail(72) |>
  augment_trends(
    value_col = "consumption",
    methods = "median",
    window = 7
  )

}
