% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_findingemo.R
\name{prepare_findingemo_evaluation}
\alias{prepare_findingemo_evaluation}
\title{Prepare FindingEmo Data for Evaluation}
\usage{
prepare_findingemo_evaluation(
  annotations,
  predictions,
  id_col = "image_id",
  truth_col = "emotion_label",
  pred_col = "predicted_emotion",
  include_va = TRUE
)
}
\arguments{
\item{annotations}{Data.frame. Annotations from \code{load_findingemo_annotations()}.}

\item{predictions}{Data.frame. Model predictions with same image IDs as annotations.}

\item{id_col}{Character. Column name for image IDs (default: "image_id").}

\item{truth_col}{Character. Column name for ground truth emotions (default: "emotion_label").}

\item{pred_col}{Character. Column name for predicted emotions (default: "predicted_emotion").}

\item{include_va}{Logical. Whether to include valence/arousal columns (default: TRUE).}
}
\value{
A data.frame formatted for use with \code{evaluate_emotions()}, containing:
\itemize{
  \item \code{id}: Image identifiers
  \item \code{truth}: Ground truth emotion labels
  \item \code{pred}: Predicted emotion labels
  \item \code{valence}: Valence scores (if available and include_va = TRUE)
  \item \code{arousal}: Arousal scores (if available and include_va = TRUE)
  \item Additional probability columns if present in predictions
}
}
\description{
Prepares FindingEmo dataset annotations for use with \code{evaluate_emotions()}.
Converts the dataset format to match the expected input structure for 
evaluation functions.
}
\details{
This function merges FindingEmo annotations with model predictions and formats
the result for evaluation. It handles missing values, validates data consistency,
and ensures the output matches the expected format for \code{evaluate_emotions()}.
}
\examples{
\dontrun{
# Load annotations
annotations <- load_findingemo_annotations("./findingemo_data")

# Create mock predictions (replace with actual model predictions)
predictions <- data.frame(
  image_id = annotations$image_id[1:100],
  predicted_emotion = sample(c("happy", "sad", "angry"), 100, replace = TRUE),
  prob_happy = runif(100),
  prob_sad = runif(100),
  prob_angry = runif(100)
)

# Prepare for evaluation
eval_data <- prepare_findingemo_evaluation(
  annotations = annotations,
  predictions = predictions
)

# Evaluate model performance
results <- evaluate_emotions(
  data = eval_data,
  probs_cols = c("prob_happy", "prob_sad", "prob_angry")
)

print(results)
}

}
\seealso{
\code{\link{load_findingemo_annotations}}, \code{\link{evaluate_emotions}}
}
