% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_stream.R
\name{toon_stream_rows}
\alias{toon_stream_rows}
\title{Stream tabular TOON rows}
\usage{
toon_stream_rows(
  file,
  key = NULL,
  callback,
  batch_size = 10000L,
  strict = TRUE,
  allow_comments = TRUE,
  allow_duplicate_keys = TRUE,
  warn = TRUE,
  col_types = NULL,
  ragged_rows = c("expand_warn", "error"),
  n_mismatch = c("warn", "error"),
  max_extra_cols = Inf
)
}
\arguments{
\item{file}{Character scalar. Path to TOON file.}

\item{key}{Character scalar or NULL. If non-NULL, extract tabular array at
root[key].}

\item{callback}{Function. Called with each batch as a data.frame.
Return value is ignored; exceptions propagate and abort parsing.}

\item{batch_size}{Integer. Number of rows per batch (default 10000).}

\item{strict}{Logical. If TRUE (default), enforce strict TOON syntax.}

\item{allow_comments}{Logical. If TRUE (default), allow # and // comments.}

\item{allow_duplicate_keys}{Logical. If TRUE (default), allow duplicate keys.}

\item{warn}{Logical. If TRUE (default), emit warnings.}

\item{col_types}{Named character vector specifying column types.}

\item{ragged_rows}{Character. How to handle rows with different field counts.}

\item{n_mismatch}{Character. How to handle declared row count mismatch.}

\item{max_extra_cols}{Numeric. Maximum new columns allowed.}
}
\value{
Invisibly returns NULL.
}
\description{
Stream tabular TOON rows
}
\details{
Guarantees:
\itemize{
\item Batches are independent and may be garbage collected
\item Stable column order within stream
}
}
\examples{
\dontrun{
# Stream large file in batches
toon_stream_rows("large.toon",
  callback = function(batch) {
    cat("Processing", nrow(batch), "rows\n")
  },
  batch_size = 10000
)
}

}
