% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissot.R
\name{plot.indicatrix_list}
\alias{plot.indicatrix_list}
\title{Plot a list of indicatrixes}
\usage{
\method{plot}{indicatrix_list}(
  x,
  scale = 1e+05,
  n = 72,
  col = "#FF990055",
  border = "black",
  add = FALSE,
  show.axes = TRUE,
  show.circle = TRUE,
  fill.by = NULL,
  palette = NULL,
  ncolors = 64L,
  ...
)
}
\arguments{
\item{x}{an \code{indicatrix_list} (from \code{\link[=indicatrix]{indicatrix()}})}

\item{scale}{scaling factor for ellipse size in projected units}

\item{n}{number of points per ellipse}

\item{col}{fill colour. If a single colour, used for all ellipses. If
\code{NULL} and \code{fill.by} is set, colours are generated automatically.}

\item{border}{border colour}

\item{add}{logical; add to existing plot? If \code{FALSE}, creates a new
plot sized to contain all ellipses.}

\item{show.axes}{\code{TRUE}, \code{FALSE}, or a named list of graphical parameters.
See \code{\link[=plot.indicatrix]{plot.indicatrix()}} for defaults.}

\item{show.circle}{\code{TRUE}, \code{FALSE}, or a named list of graphical parameters.
Default \code{TRUE} for the list method (the circle-vs-ellipse comparison makes
distortion visible at map scale). See \code{\link[=plot.indicatrix]{plot.indicatrix()}} for defaults.}

\item{fill.by}{character; name of a distortion metric to colour-code
the fill. One of \code{"scale_area"}, \code{"angle_deformation"}, \code{"scale_h"},
\code{"scale_k"}, \code{"scale_a"}, \code{"scale_b"}. Default \code{NULL} (uniform fill).}

\item{palette}{colour palette function (default \code{\link[grDevices:palettes]{grDevices::hcl.colors()}})}

\item{ncolors}{number of colours in the palette (default 64)}

\item{...}{passed to \code{\link[=plot.indicatrix]{plot.indicatrix()}}}
}
\value{
The input \code{x}, invisibly.
}
\description{
Draws all indicatrixes in an \code{indicatrix_list}, optionally creating a
new plot or adding to an existing one. Can colour-code the fill by a
distortion metric.
}
\examples{
xy <- expand.grid(seq(-150, 150, by = 30), seq(-60, 60, by = 30))
r <- tissot(xy, "+proj=robin")
ii <- indicatrix(r)

## Uniform fill
plot(ii, scale = 6e5, add = FALSE)
tissot_map()

## Colour by areal distortion
plot(ii, scale = 6e5, add = FALSE, fill.by = "scale_area")
tissot_map()
}
\seealso{
\code{\link[=indicatrix]{indicatrix()}}, \code{\link[=plot.indicatrix]{plot.indicatrix()}}, \code{\link[=tissot_map]{tissot_map()}}
}
