% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s_pattern.R
\name{s_pattern}
\alias{s_pattern}
\alias{s_regex}
\alias{s_fixed}
\alias{s_coll}
\alias{s_chrcls}
\title{Pattern Specifications for String Related Operators}
\usage{
s_regex(
  p,
  case_insensitive,
  comments,
  dotall,
  multiline,
  time_limit,
  stack_limit,
  ...
)

s_fixed(p, case_insensitive, overlap, ...)

s_coll(
  p,
  locale,
  strength,
  alternate_shifted,
  french,
  uppercase_first,
  case_level,
  numeric,
  normalization,
  ...
)

s_chrcls(p, ...)
}
\arguments{
\item{p}{a character vector giving the pattern to search for. \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_regex.html}{\figure{aboutsearch-regex-darkred.svg}{options: alt='[REGEX]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_regex.html}{about search: regex}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_fixed.html}{\figure{aboutsearch-fixed-darkgreen.svg}{options: alt='[FIXED]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_fixed.html}{about search: fixed}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_coll.html}{\figure{aboutsearch-coll-pink.svg}{options: alt='[COLL]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_coll.html}{about search: coll}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_charclass.html}{\figure{aboutsearch-charclass-lightyellow.svg}{options: alt='[CHARCLASS]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_charclass.html}{about search: charclass}} \cr}

\item{case_insensitive}{see \link[stringi]{stri_opts_regex} and \link[stringi]{stri_opts_fixed}.}

\item{comments, dotall, multiline}{see \link[stringi]{stri_opts_regex}.}

\item{time_limit, stack_limit}{see \link[stringi]{stri_opts_regex}.}

\item{...}{additional arguments not part of the \code{stri_opts} - functions to be passed here. \cr
For example: the \code{at} argument for the \link{str_search} operators.}

\item{overlap}{see \link[stringi]{stri_opts_fixed}.}

\item{locale, strength, alternate_shifted}{see \link[stringi]{stri_opts_collator}.}

\item{french, normalization, numeric}{see \link[stringi]{stri_opts_collator}.}

\item{uppercase_first, case_level}{see \link[stringi]{stri_opts_collator}.}
}
\value{
A list with arguments to be passed to the appropriate operators.
}
\description{
The \link[=str_arithmetic]{\%s-\%, \%s/\%, \%ss\%} operators,
as well as the string search operators (\link{str_search}),
perform pattern matching for some purpose,
where the pattern is given in the second argument (\code{p}). \cr
When a character vector or string is given as the second argument (\code{p}),
this is interpreted as case-sensitive
\code{regex} patterns from 'stringi'. \cr
\cr
Instead of giving a string or character vector of regex patterns,
one can also supply a list to specify exactly how the pattern should be interpreted.
The list should use the exact same argument convention as 'stringi'. \cr
\cr
For example:
\itemize{
\item \code{list(regex = p, case_insensitive = FALSE, ...)}
\item \code{list(fixed = p, ...)}
\item \code{list(coll = p, ...)}
\item \code{list(charclass = p, ...)}
}

All arguments in the list are simply passed to the
appropriate functions in 'stringi'. \cr
For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x \%s/\% p
}\if{html}{\out{</div>}}

counts how often regular expression specified in character vector
\code{p} occurs in \code{x}, whereas the following,

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x \%s/\% list(fixed = p, case_insensitive = TRUE)
}\if{html}{\out{</div>}}

will do the same,
except it uses fixed (i.e. literal) expression,
and it does not distinguish between upper case and lower case characters. \cr
\cr
'tinycodet' adds some convenience functions based on
the \code{stri_opts_} - functions in 'stringi':
\itemize{
\item \code{s_regex(p, ...)} is equivalent to \code{list(regex = p, ...)}
\item \code{s_fixed(p, ...)} is equivalent to \code{list(fixed = p, ...)}
\item \code{s_coll(p, ...)} is equivalent to \code{list(coll = p, ...)}
\item \code{s_chrcls(p, ...)} is equivalent to \code{list(charclass = p, ... )}
}

With the ellipsis (\code{...})
being passed to the appropriate
'stringi'-functions
when it matches their arguments. \cr
\cr
'stringi' infix operators start with "\code{\%s}",
though they all have an alias starting with "\code{\%stri}".
In analogy to that, the above functions start with "\code{s_}"
rather than "\code{stri_}", as they are all meant for operators only. \cr
}
\examples{


x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
p <- rep("a|e|i|o|u", 2) # same as p <- list(regex = rep("a|e|i|o|u", 2))
x \%s/\% p # count how often vowels appear in each string of vector x.

x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
x \%s/\% list(regex = rep("A|E|I|O|U", 2), case_insensitive = TRUE)
x \%s/\% s_regex(rep("A|E|I|O|U", 2), case_insensitive = TRUE)


x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
p <- list(fixed = c("A", "A"), case_insensitive = TRUE)
x \%s{}\% p
x \%s!{}\% p
p <- s_fixed(c("A", "A"), case_insensitive = TRUE)
x \%s{}\% p
x \%s!{}\% p

x <- c(paste0(letters[1:13], collapse = ""),
      paste0(letters[14:26], collapse = ""), NA)
p <- s_fixed("abc", at = "start")
x \%s{}\% p
stringi::stri_startswith(x, fixed = "abc") # same as above

p <- s_fixed("xyz", at = "end")
x \%s{}\% p
stringi::stri_endswith(x, fixed = "xyz") # same as above

}
\seealso{
\link{tinycodet_strings}
}
