% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_sequence_api.R
\name{visit_sequence_api}
\alias{visit_sequence_api}
\alias{update_visit_sequence}
\alias{reset_visit_sequence}
\title{Add or reset a \code{visit_sequence} object within an existing \code{roadmap}.}
\usage{
update_visit_sequence(roadmap, ...)

reset_visit_sequence(roadmap)
}
\arguments{
\item{roadmap}{A \code{roadmap} object}

\item{...}{Optional additional parameters.}
}
\value{
A new \code{roadmap} object.

A roadmap with an updated visit_sequence.

A new \code{roadmap} object with reset visit_sequence.
}
\description{
Add or reset a \code{visit_sequence} object within an existing \code{roadmap}.
}
\examples{

rm <- roadmap(
  conf_data = acs_conf_nw, 
  start_data = acs_start_nw
) 

rm |>
  update_visit_sequence(
    weight_var = wgt,
    synthesize_weight = TRUE
  )


rm <- roadmap(
  conf_data = acs_conf_nw, 
  start_data = acs_start_nw
) 

rm <- rm |>
  update_visit_sequence(
    weight_var = wgt,
    synthesize_weight = TRUE
  )

reset_visit_sequence(roadmap = rm)

}
