% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth_spec.R
\name{synth_spec_tuner_api}
\alias{synth_spec_tuner_api}
\alias{add_custom_tuners}
\alias{update_custom_tuners}
\alias{remove_custom_tuners}
\title{Add, update, or remove tuners from a \code{synth_spec} object}
\usage{
add_custom_tuners(synth_spec, ...)

update_custom_tuners(synth_spec, ...)

remove_custom_tuners(synth_spec)
}
\arguments{
\item{synth_spec}{A \code{synth_spec} object}

\item{...}{Optional named lists with two elements, \code{vars} and \code{tuner},
mapping variable names to tuners.}
}
\value{
A new \code{synth_spec} object.

A new \code{synth_spec} object with added custom tuners.

A new \code{synth_spec} object with updated custom tuners.

A new \code{synth_spec} object with removed custom tuners.
}
\description{
Add, update, or remove tuners from a \code{synth_spec} object
}
\examples{

synth_spec <- synth_spec()

tuner1 <- list(
  v = 3,
  grid = 3,
  metrics = yardstick::metric_set(yardstick::rmse)
)

add_custom_tuners(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "tuner" = tuner1)
)


synth_spec <- synth_spec()

tuner1 <- list(
  v = 3,
  grid = 3,
  metrics = yardstick::metric_set(yardstick::rmse)
)

update_custom_tuners(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "tuner" = tuner1)
)


synth_spec <- synth_spec()

tuner1 <- list(
  v = 3,
  grid = 3,
  metrics = yardstick::metric_set(yardstick::rmse)
)

synth_spec <- add_custom_tuners(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "tuner" = tuner1)
)

remove_custom_tuners(synth_spec = synth_spec)

}
