% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth_spec.R
\name{synth_spec_sampler_api}
\alias{synth_spec_sampler_api}
\alias{add_custom_samplers}
\alias{update_custom_samplers}
\alias{remove_custom_samplers}
\alias{update_custom_noise}
\alias{remove_custom_noise}
\title{Add, update, or remove samplers from a \code{synth_spec} object}
\usage{
add_custom_samplers(synth_spec, ...)

update_custom_samplers(synth_spec, ...)

remove_custom_samplers(synth_spec)

update_custom_noise(synth_spec, ...)

remove_custom_noise(synth_spec)
}
\arguments{
\item{synth_spec}{A \code{synth_spec} object}

\item{...}{Optional named lists with two elements, \code{vars} and \code{sampler},
mapping variable names to samplers.}
}
\value{
A new \code{synth_spec} object.

A new \code{synth_spec} object with added custom samplers.

A new \code{synth_spec} object with updated custom samplers.

A new \code{synth_spec} object with removed custom samplers.

A new \code{synth_spec} object with updated custom noise.

A new \code{synth_spec} object with removed custom noise.
}
\description{
Add, update, or remove samplers from a \code{synth_spec} object
}
\examples{

synth_spec <- synth_spec()

add_custom_samplers(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "sampler" = sample_rpart)
)


synth_spec <- synth_spec()

update_custom_samplers(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "sampler" = sample_rpart)
)


synth_spec <- synth_spec()

synth_spec <- add_custom_samplers(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "sampler" = sample_rpart)
)

remove_custom_samplers(synth_spec = synth_spec)


synth_spec <- synth_spec()

noise1 <- noise(
  add_noise = TRUE, 
  noise_func = add_noise_kde,
  noise_params = list(
    n_ntiles = 2
  )
)

update_custom_noise(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "noise" = noise1)
)


synth_spec <- synth_spec()

noise1 <- noise(
  add_noise = TRUE, 
  noise_func = add_noise_kde,
  noise_params = list(
    n_ntiles = 2
  )
)

synth_spec <- add_custom_noise(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "noise" = noise1)
)

remove_custom_noise(synth_spec = synth_spec)

}
