% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_glm.R
\name{sample_glm}
\alias{sample_glm}
\title{Sample the conditional distribution created by a generalized linear model}
\usage{
sample_glm(model, new_data, conf_data)
}
\arguments{
\item{model}{A "model_fit" object created by parsnip}

\item{new_data}{A data frame with predictors}

\item{conf_data}{A data frame with original confidential predictors}
}
\value{
A numeric vector of predictions
}
\description{
Currently, logistic and poisson regression are supported using \code{parsnip} and
the standard \code{glm} engine. Note that poisson regression requires the suggested
\code{poissonreg} library.
}
\examples{

acs_conf <- acs_conf |>
  tidyr::drop_na()

logistic_mod <- parsnip::logistic_reg() |>
  parsnip::set_engine("glm") |>
  parsnip::set_mode(mode = "classification")

classification_rec <- recipes::recipe(hcovany ~ ., data = acs_conf)

model_class <- workflows::workflow() |>
  workflows::add_model(spec = logistic_mod) |>
  workflows::add_recipe(recipe = classification_rec) |>
  parsnip::fit(data = acs_conf)

set.seed(1)
sample1 <- sample_glm(
  model = model_class, 
  new_data = acs_conf[1:3, ], 
  conf_data = acs_conf
)

}
