% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_noise_laplace.R
\name{add_noise_laplace}
\alias{add_noise_laplace}
\title{Add Laplace noise with mean 0 to predicted values with constant variance}
\usage{
add_noise_laplace(
  model,
  new_data,
  conf_model_data,
  outcome_var,
  col_schema,
  pred,
  variance = NULL,
  epsilon = NULL,
  sensitivity = NULL
)
}
\arguments{
\item{model}{A \code{model_spec} or a list of \code{model_spec}s from \code{library(parsnip)}}

\item{new_data}{A data frame used to generate predictions}

\item{conf_model_data}{A data frame for estimating the predictive model}

\item{outcome_var}{A string name representing the outcome variable}

\item{col_schema}{A list of column schema specifications for the new variable}

\item{pred}{A vector of values predicted by the model}

\item{variance}{Sampling variance for additive noise}

\item{epsilon}{Alternative privacy loss budget prescribed by the Laplace
mechanism under epsilon differential privacy.}

\item{sensitivity}{Alternative sample sensitivity prescribed by the Laplace
mechanism under epsilon differential privacy.}
}
\value{
A numeric vector with noise added to each prediction
}
\description{
Add Laplace noise with mean 0 to predicted values with constant variance
}
\examples{

add_noise_laplace(
  model = NULL,
  new_data = NULL,
  conf_model_data = NULL,
  outcome_var = NULL,
  col_schema = NULL,
  pred = 1:100,
  variance = 3
)

}
