% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_high_relatedness.R
\name{filter_high_relatedness}
\alias{filter_high_relatedness}
\title{Filter individuals based on a relationship threshold}
\usage{
filter_high_relatedness(
  matrix,
  .x = NULL,
  kings_threshold = NULL,
  verbose = FALSE
)
}
\arguments{
\item{matrix}{a square symmetric matrix of individuals containing
relationship coefficients}

\item{.x}{a \code{\link{gen_tibble}} object}

\item{kings_threshold}{a threshold over which}

\item{verbose}{boolean whether to report to screen}
}
\value{
a list where '1' is individual ID's to retain, '2' is individual ID's
to remove, and '3' is a boolean where individuals to keep are TRUE and
individuals to remove are FALSE
}
\description{
This function takes a matrix of x by y individuals containing relatedness
coefficients and returns the maximum set of individuals that contains no
relationships above the given threshold.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Calculate relationship matrix
king_matrix <- example_gt \%>\% pairwise_king(as_matrix = TRUE)

# Filter individuals with threshold above 0.2
filter_high_relatedness(king_matrix, example_gt, kings_threshold = 0.2)
}
