% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{tl_reduce_dimensions}
\alias{tl_reduce_dimensions}
\title{Integration Functions: Combining Supervised and Unsupervised Learning}
\usage{
tl_reduce_dimensions(
  data,
  response = NULL,
  method = "pca",
  n_components = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{response}{Response variable name (will be preserved)}

\item{method}{Dimensionality reduction method: "pca", "mds"}

\item{n_components}{Number of components to retain}

\item{...}{Additional arguments for the dimensionality reduction method}
}
\value{
A list containing the transformed data and the reduction model
}
\description{
These functions demonstrate the power of tidylearn's unified approach by
seamlessly integrating supervised and unsupervised learning techniques.
Feature Engineering via Dimensionality Reduction
}
\details{
Use PCA, MDS, or other dimensionality reduction as a preprocessing step
for supervised learning. This can improve model performance and interpretability.
}
\examples{
\donttest{
# Reduce dimensions before classification
reduced <- tl_reduce_dimensions(iris, response = "Species", method = "pca", n_components = 3)
model <- tl_model(reduced$data, Species ~ ., method = "logistic")
}
}
