% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_items.R
\name{code}
\alias{code}
\alias{code.character}
\alias{code.code_list}
\alias{add_level}
\title{Code Text Data}
\usage{
code(x, ...)

\method{code}{character}(x, similarity = c("stringdist", "embeddings"), ...)

\method{code}{code_list}(x, label = NULL, ...)

add_level(x, similarity = NULL, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{...}{Additional arguments passed to functions.}

\item{similarity}{Which method to use to compute similarity between entries.
Defaults to \code{"stringdist"}, which uses \link[stringdist]{stringdistmatrix}.
Option \code{"embeddings"} additionally requires passing the named argument
\code{"model_path"}, which should point to a LLM downloaded with
\link[theorytools]{download_huggingface}.}

\item{label}{Label to assign to elements identified via numeric indexing,
passed via \code{...}.}
}
\value{
A \code{list} with class \code{code_list}.
}
\description{
Create a reproducible script for coding qualitative text data by
sequentially assigning elements of \code{x} to specific labels.
}
\section{Functions}{
\itemize{
\item \code{add_level()}: In case of nested coding, use \code{add_level()} to add a level of
coding to a \code{code_list} object.

}}
\examples{
x <- c("autonomy [satisfaction] increases",
"competence [satisfaction] increases", "relatedness [satisfaction] increases"
, "motivation is more internalized", "motivation is more internalized",
"motivation is more internalized1", "event is more controlling",
"event is more controlling",
"event communicates more effectance information")
coded <- code(x)
coded <- code(coded, "need_satisfaction", 1:3)
coded <- code(coded, "internalization", 1:3)
coded <- code(coded, "functional_significance", 1:3)
coded <- add_level(coded)
coded <- code(coded, "random_level1", 1:2)
coded <- code(coded, "random_level2", 1)
coded
}
