% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_factor.R
\name{factor_utils}
\alias{factor_utils}
\alias{combine_levels}
\alias{as_factor_keep_attributes}
\alias{fct_discard}
\alias{fct_explicit_na_if}
\alias{fct_collapse_only}
\title{Factor utilities}
\usage{
combine_levels(x, levels, new_level = paste(levels, collapse = "/"))

as_factor_keep_attributes(
  x,
  x_name = deparse(substitute(x)),
  na_level = "<Missing>",
  verbose = TRUE
)

fct_discard(x, discard)

fct_explicit_na_if(x, condition, na_level = "<Missing>")

fct_collapse_only(.f, ..., .na_level = "<Missing>")
}
\arguments{
\item{x}{(\code{factor})\cr factor variable or object to convert (for \code{as_factor_keep_attributes}).}

\item{levels}{(\code{character})\cr level names to be combined.}

\item{new_level}{(\code{string})\cr name of new level.}

\item{x_name}{(\code{string})\cr name of \code{x}.}

\item{na_level}{(\code{string})\cr which level to use for missing values.}

\item{verbose}{(\code{flag})\cr defaults to \code{TRUE}. It prints out warnings and messages.}

\item{discard}{(\code{character})\cr levels to discard.}

\item{condition}{(\code{logical})\cr positions at which to insert missing values.}

\item{.f}{(\code{factor} or \code{character})\cr original vector.}

\item{...}{(named \code{character})\cr levels in each vector provided will be collapsed into
the new level given by the respective name.}

\item{.na_level}{(\code{string})\cr which level to use for other levels, which should be missing in the
new factor. Note that this level must not be contained in the new levels specified in \code{...}.}
}
\value{
\itemize{
\item \code{combine_levels}: A \code{factor} with the new levels.
}

\itemize{
\item \code{as_factor_keep_attributes}: A \code{factor} with same attributes (except class) as \code{x}.
Does not modify \code{x} if already a \code{factor}.
}

\itemize{
\item \code{fct_discard}: A modified \code{factor} with observations as well as levels from \code{discard} dropped.
}

\itemize{
\item \code{fct_explicit_na_if}: A modified \code{factor} with inserted and existing \code{NA} converted to \code{na_level}.
}

\itemize{
\item \code{fct_collapse_only}: A modified \code{factor} with collapsed levels. Values and levels which are not included
in the given \code{character} vector input will be set to the missing level \code{.na_level}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A collection of utility functions for factors.
}
\section{Functions}{
\itemize{
\item \code{combine_levels()}: Combine specified old factor Levels in a single new level.

\item \code{as_factor_keep_attributes()}: Converts \code{x} to a factor and keeps its attributes. Warns appropriately such that the user
can decide whether they prefer converting to factor manually (e.g. for full control of
factor levels).

\item \code{fct_discard()}: This discards the observations as well as the levels specified from a factor.

\item \code{fct_explicit_na_if()}: This inserts explicit missing values in a factor based on a condition. Additionally,
existing \code{NA} values will be explicitly converted to given \code{na_level}.

\item \code{fct_collapse_only()}: This collapses levels and only keeps those new group levels, in the order provided.
The returned factor has levels in the order given, with the possible missing level last (this will
only be included if there are missing values).

}}
\note{
Any existing \code{NA}s in the input vector will not be replaced by the missing level. If needed,
\code{\link[=explicit_na]{explicit_na()}} can be called separately on the result.
}
\examples{
x <- factor(letters[1:5], levels = letters[5:1])
combine_levels(x, levels = c("a", "b"))

combine_levels(x, c("e", "b"))

a_chr_with_labels <- c("a", "b", NA)
attr(a_chr_with_labels, "label") <- "A character vector with labels"
as_factor_keep_attributes(a_chr_with_labels)

fct_discard(factor(c("a", "b", "c")), "c")

fct_explicit_na_if(factor(c("a", "b", NA)), c(TRUE, FALSE, FALSE))

fct_collapse_only(factor(c("a", "b", "c", "d")), TRT = "b", CTRL = c("c", "d"))

}
\seealso{
\code{\link[=cut_quantile_bins]{cut_quantile_bins()}} for splitting numeric vectors into quantile bins.

\code{\link[forcats:fct_na_value_to_level]{forcats::fct_na_value_to_level()}} which is used internally.

\code{\link[forcats:fct_collapse]{forcats::fct_collapse()}}, \code{\link[forcats:fct_relevel]{forcats::fct_relevel()}} which are used internally.
}
