% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch.R
\name{pitch_seq}
\alias{pitch_seq}
\title{Create a sequence from pitch notation}
\usage{
pitch_seq(x, y, key = NULL, scale = NULL, format = c("space", "vector"))
}
\arguments{
\item{x}{character, valid pitch notation, e.g., \code{"a2"} or \code{"a,"}.}

\item{y}{character, same as \code{x} for the sequence \code{x:y}. If a number, the
length of the sequence from \code{x} and the sign of \code{y} determines the direction.}

\item{key}{character, key signature for a diatonic sequence.
\code{key = NULL} (default) results in a chromatic sequence.}

\item{scale}{character, if you want to use a different scale in conjunction
with the key/root note, you can provide it, e.g., \code{scale = "harmonic minor"}.
Ignored if \code{key = NULL}.}

\item{format}{character, the timestep delimiter format, \code{"space"} or
\code{"vector"}.}
}
\value{
noteworthy
}
\description{
Create a noteworthy string of a sequence of consecutive pitches.
}
\details{
Note that all pitches resulting from the defined sequence must be in the
semitone range 0-131 or an error is thrown.

If not using a chromatic sequence and \code{x} (or \code{y} if also a pitch) is not
part of the key signature or scale, the sequence is internally bound. See
examples.

Format of accidentals in the result is prioritized by the scale and key, the
key when no scale is given, then \code{x} (and \code{y} if also a pitch), and finally
defaults to flats if ambiguous.
}
\examples{
# chromatic sequence (default)
pitch_seq("a,", 13)
pitch_seq("c5", -2)
pitch_seq("c", "b")

# diatonic sequence
pitch_seq("c", 8, key = "c")
pitch_seq("c", 8, "am")
pitch_seq("c#,", "a#'", "am")

# combine with alternative scale
pitch_seq("a", 8, "am", "harmonic minor")
}
