% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midi.R
\name{miditab}
\alias{miditab}
\title{Convert MIDI to tablature}
\usage{
miditab(midi_file, file, keep_ly = FALSE, details = FALSE, ...)
}
\arguments{
\item{midi_file}{character, MIDI file (\code{.mid}). May include an absolute
or relative path.}

\item{file}{character, output file ending in .pdf or .png.}

\item{keep_ly}{logical, keep LilyPond file.}

\item{details}{logical, set to \code{TRUE} to print LilyPond log output to
console. Windows only.}

\item{...}{additional arguments passed to \code{\link[=midily]{midily()}}.}
}
\value{
nothing returned; a file is written.
}
\description{
Convert a MIDI file to  sheet music/guitar tablature.
}
\details{
Under development/testing. See warning and details below.

Convert a MIDI file to a pdf or png music score using the LilyPond music
engraving program.
Output format is inferred from \code{file} extension. This function is a wrapper
around \code{\link[=midily]{midily()}}, the function that converts the MIDI file to a LilyPond
(\code{.ly}) file using a LilyPond command line utility.

WARNING: Even though the purpose of the command line utility is to convert
an existing MIDI file to a LilyPond file, it nevertheless generates a
LilyPond file that \emph{specifies inclusion of MIDI output}.
This means when you subsequently process the LilyPond file with LilyPond or
if you use \code{miditab()} to go straight from your MIDI file to pdf output,
the command line tool will also produce a MIDI file output. It will
overwrite your original MIDI file if it has the same file name and location!

On Windows systems, it may be necessary to specify a path in \code{\link[=tabr_options]{tabr_options()}}
to both \code{midi2ly} and \code{python} if they are not already added to the system
PATH variable.
}
\examples{
\dontrun{
if(tabr_options()$midi2ly != ""){
  midi <- system.file("example.mid", package = "tabr")
  outfile <- file.path(tempdir(), "out.pdf")
  miditab(midi, outfile, details = FALSE) # requires LilyPond installation
}
}
}
\seealso{
\code{\link[=midily]{midily()}}, \code{\link[=tab]{tab()}}, \code{\link[=lilypond]{lilypond()}}
}
