% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{get_com_offset}
\alias{get_com_offset}
\title{Horizontal offset of center of mass from QSM}
\usage{
get_com_offset(qsm)
}
\arguments{
\item{qsm}{a QSM loaded using `[load_qsm()]`.}
}
\value{
A single numeric value giving the horizontal distance (m)
between the base of the tree and the volume-weighted center of mass.
}
\description{
This function extracts the horizontal distance between the base of a tree and
the center of a tree from a QSM. The function takes the coordinate of the
lowest QSM segment, and the center of mass, and finds the horizontal
distance between them.
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
print(get_center_of_mass(qsm))
print(get_com_offset(qsm))
}
