% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{fit_taper_Kozak}
\alias{fit_taper_Kozak}
\title{Fit taper equation to QSM}
\usage{
fit_taper_Kozak(
  qsm,
  dbh,
  terminus_diam_cm = 4,
  segment_size = 0.25,
  plot = TRUE
)
}
\arguments{
\item{qsm}{a QSM loaded using `[load_qsm()]`.}

\item{dbh}{numeric -- required to fit Kozak model, not calculated from QSM, so
as not to conflict with other more accurate means of measurement e.g., `get_DBH'}

\item{terminus_diam_cm}{numeric -- the trunk diameter at which is no longer
considered trunk}

\item{segment_size}{numeric -- the length of segments that QSM cylinders are
grouped into}

\item{plot}{boolean -- indicates whether model output should be plotted. Plots
are found in the output list as object$plot, regardless of this setting.}
}
\value{
A list with components:
\describe{
  \item{data}{Tibble of trunk segment heights and observed diameters used in model fitting.}
  \item{plot}{A `ggplot2` object showing observed diameters and fitted taper curve.}
  \item{results}{Data frame containing fitted Kozak parameters (`a0`–`a3`),
  coefficient of determination (`r2`), and root mean squared error (`rmse`).}
}
}
\description{
This function fits a taper equation to trunk sections of a QSM using
Kozak the Model (2002, 2007).
}
\details{
$ d(h)/D = a0 (h/H) + a1 (h/H) + a2 (h/H)^2 + a3 (h/H)^3 $

The function groups QSM cylinders into segments of `segment_size` up to
`terminus_diam` which is the maximum diameter at which the taper equation
ends.
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
fit_taper_Kozak(qsm, dbh = 13.8)
}
