% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{extract_patch_params}
\alias{extract_patch_params}
\title{Extract patch diameter parameters from a QSM filename}
\usage{
extract_patch_params(
  filepath,
  default_patch1,
  default_patch2min,
  default_patch2max
)
}
\arguments{
\item{filepath}{Character. Full path to the QSM file.}

\item{default_patch1}{Numeric. Default value for D (patch_diam1).}

\item{default_patch2min}{Numeric. Default value for DI (patch_diam2min).}

\item{default_patch2max}{Numeric. Default value for DA (patch_diam2max).}
}
\value{
A named list with elements `patch_diam1`,
`patch_diam2min`, and `patch_diam2max`.
}
\description{
Internal helper function to parse patch diameters (D, DI, DA) from
a PyTLidar-generated QSM filename. Falls back to default values if not present.
}
\keyword{internal}
