% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{branch_size_distribution}
\alias{branch_size_distribution}
\title{Get Branch size distribution from a QSM}
\usage{
branch_size_distribution(qsm, breaks = NULL, plot = TRUE)
}
\arguments{
\item{qsm}{-- a QSM loaded using `[load_qsm()]`.}

\item{breaks}{numeric -- a vector of diameter classes (in cm) by which to
summarize branch volume. If `NULL` the branch of branch sizes will be
distributed across 1 cm bins.}

\item{plot}{boolean -- indicates whether the branch diameter distribution
should be plotted as a histogram.}
}
\value{
A tibble summarizing branch volume by diameter class with columns:
\describe{
  \item{diameter_cm}{Factor indicating the diameter class (cm).}
  \item{midpoint}{Numeric midpoint (cm) of each diameter class.}
  \item{volume_mL}{Total branch volume (mL) within the class.}
}
Returns `NA` if fewer than two branch cylinders are present.
}
\description{
This function outputs the volume (in mL) distribution of branches across
different branch diameter classes (in cm). Outputs a table that can be used
in other functions to find branch_skewness or branch_volume_weighted_stats()
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
branch_distribution = branch_size_distribution(qsm, plot=TRUE)
print(branch_distribution)

#volume-weighted mean
branch_volume_weighted_stats(qsm, FUN = function(x) mean(x))

#volume-weighted median
branch_volume_weighted_stats(qsm, FUN = function(x) median(x))

# volume-weighted skewness
branch_volume_weighted_stats(qsm, FUN = function(x) 3*(mean(x) - median(x)) / sd(x))
}
