% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_directories.R
\name{compare_directories}
\alias{compare_directories}
\title{Compare Two Directories for Synchronization Status}
\usage{
compare_directories(
  left_path,
  right_path,
  recurse = TRUE,
  by_date = TRUE,
  by_content = FALSE,
  verbose = getOption("syncdr.verbose")
)
}
\arguments{
\item{left_path}{Path to the left/first directory.}

\item{right_path}{Path to the right/second directory.}

\item{recurse}{If TRUE, fully recurses through subdirectories. If a positive integer, specifies the number of levels to recurse.}

\item{by_date}{Logical. If TRUE (default), compares directories based on the modification date of common files.}

\item{by_content}{Logical. If TRUE, compares directories based on the hashed content of common files. Default is FALSE}

\item{verbose}{Logical. If TRUE display additional info on the comparison process. Default is FALSE}
}
\value{
A list of class "syncdr_status" containing the following elements:
\itemize{
\item Non-common files: Paths and synchronization status of files exclusive to either directory.
\item Common files: Paths and synchronization status of files present in both directories.
\item Path of the left directory.
\item Path of the right directory.
}
}
\description{
This function compares two directories, typically referred to as 'left' and 'right', to determine their synchronization status at the file level.
The primary goal is to identify the synchronization status of files present in both directories and those exclusive to either directory.
}
\section{Sync Status Types}{

The synchronization status is determined for files present in both directories, as well as for files exclusive to either directory.
It can be computed based on modification date only, content only, or both.

For Common Files:
\itemize{
\item When comparing by date: 'new', 'old', or 'same'.
\item When comparing by date and content: 'new and different', 'new and same', 'old and different', 'old and same', 'same and different', or 'same and same'.
\item When comparing by content only: 'different' or 'same'.
}

For Non-Common Files:
\itemize{
\item When comparing by date (or by date and content, or by content only): 'only in left' or 'only in right'.
}
}

\examples{
\donttest{
e <- toy_dirs()
left  <- e$left
right <- e$right
compare_directories(left, right)
compare_directories(left, right, by_content = TRUE)
compare_directories(left, right, by_content = TRUE, by_date = FALSE)
}
}
