% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.survextrap}
\alias{plot.survextrap}
\title{Plot method for survextrap model objects}
\usage{
\method{plot}{survextrap}(x, type = "hazsurv", newdata = NULL, ...)
}
\arguments{
\item{x}{A fitted model object as returned by \code{\link{survextrap}}}

\item{type}{\code{"survival"} for a plot of the survival function, \code{"hazard"} for the hazard function, against time.}

\item{newdata}{Data frame of covariate values to compute the output for.
If there are covariates in the model and this is not supplied,
the following default is used:

(a) if the only covariate is one factor variable, then the output is computed
for each level of this factor.

(b) if there are multiple covariates, or any numeric covariates, then the output
is computed at the mean of each numeric covariate in the original data, and at the
baseline level of each factor covariate.

Note: caution is required about how treatment groups (for example)
are stored in your data.  If these are coded as numeric (0/1),
then if \code{newdata} is not specified, only one output will be shown.
This relates to the average value of this numeric variable over
the data, which doesn't correspond to either of the treatment
groups.  To avoid this, a treatment group should be stored as a
factor.}

\item{...}{Additional arguments, passed on to \code{plot_hazard} and \code{plot_survival}.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
Intended as a quick check of the results of a model fit.   See
\code{\link{plot_survival}} and \code{\link{plot_hazard}} for
the functions behind each panel, and \code{\link{survival}}
and \code{\link{hazard}} to extract the data being plotted here
to enable custom plots like these.
}
