% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surreal-image.R
\name{surreal_image}
\alias{surreal_image}
\title{Apply the surreal method to an image file}
\usage{
surreal_image(
  image_path,
  mode = "auto",
  threshold = NULL,
  max_points = NULL,
  invert_y = TRUE,
  R_squared = 0.3,
  p = 5,
  n_add_points = 40,
  max_iter = 100,
  tolerance = 0.01,
  verbose = FALSE
)
}
\arguments{
\item{image_path}{Character. Path to an image file or a URL (PNG, JPEG, BMP, TIFF, or SVG).}

\item{mode}{Character. Either \code{"auto"} (default) to automatically detect,
\code{"dark"} to select dark pixels, or \code{"light"} to select light pixels.}

\item{threshold}{Numeric or \code{NULL}. Value between 0 and 1 for grayscale
threshold. If \code{NULL} (default), automatically calculated using Otsu's method.
For \code{"dark"} mode, pixels below threshold are selected.
For \code{"light"} mode, pixels above threshold are selected.}

\item{max_points}{Integer or \code{NULL}. Maximum number of points to use. If
\code{NULL} (default), automatically estimated based on image size (typically
2000-5000 points). Set to \code{Inf} to use all points without downsampling.}

\item{invert_y}{Logical. If \code{TRUE}, flip y-coordinates so image appears
right-side up in residual plot. Default is \code{TRUE}.}

\item{R_squared}{Numeric. Desired R-squared value. Default is 0.3.}

\item{p}{Integer. Desired number of columns for matrix X. Default is 5.}

\item{n_add_points}{Integer. Number of points to add in border transformation. Default is 40.}

\item{max_iter}{Integer. Maximum number of iterations for convergence. Default is 100.}

\item{tolerance}{Numeric. Criteria for detecting convergence and stopping optimization early. Default is 0.01.}

\item{verbose}{Logical. If TRUE, prints progress information. Default is FALSE.}
}
\value{
A \code{data.frame} containing the results of the surreal method
application with columns \code{y}, \code{X1}, \code{X2}, ..., \code{Xp}.
}
\description{
This function loads an image file, extracts pixel coordinates based on
a brightness threshold, and applies the surreal method to create a dataset
where the image appears in the residual plot.
}
\details{
By default, all parameters are automatically detected:
\itemize{
\item \strong{mode}: Detected from image histogram (dark subject on light background or vice versa)
\item \strong{threshold}: Calculated using Otsu's method to optimally separate foreground/background
\item \strong{max_points}: Estimated based on image dimensions (2000-5000 points)
}

You can override any of these by specifying explicit values.

\strong{Input Support:}
\itemize{
\item Local file paths
\item URLs (http:// or https://) - images are downloaded to a temporary file
}

\strong{Format Support:}
\itemize{
\item PNG: Supported via the \code{png} package (included)
\item JPEG: Requires the \code{jpeg} package
\item BMP: Requires the \code{bmp} package
\item TIFF: Requires the \code{tiff} package
\item SVG: Requires the \code{rsvg} package (renders vector graphics to bitmap)
}
}
\examples{
\dontrun{
# Simplest usage - everything auto-detected
result <- surreal_image("https://www.r-project.org/logo/Rlogo.png")
model <- lm(y ~ ., data = result)
plot(model$fitted, model$residuals, pch = 16)

# Override specific parameters
result <- surreal_image("image.png", mode = "dark", threshold = 0.3)

# Use all points (no downsampling)
result <- surreal_image("image.png", max_points = Inf)
}

}
\seealso{
\code{\link[=surreal]{surreal()}} for details on the surreal method parameters.
\code{\link[=surreal_text]{surreal_text()}} for embedding text instead of images.
}
