% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_pvalue.R
\name{format_pvalue}
\alias{format_pvalue}
\title{Format P-Values for Display}
\usage{
format_pvalue(p, digits = 4, include_p = FALSE)
}
\arguments{
\item{p}{A numeric vector of p-values to format.}

\item{digits}{Number of decimal places to round to. Default is 4.}

\item{include_p}{Logical. If TRUE, includes "p" prefix before the formatted
value (e.g., "p = .05"). Default is FALSE.}
}
\value{
A character vector of formatted p-values.
}
\description{
Formats p-values for clean display in figures and tables. e.g., p = .0231, p<.0001
}
\examples{
# Basic usage
format_pvalue(0.05)
format_pvalue(0.0001)

# More rounding
format_pvalue(0.0001,digits=2)

# Vector input
format_pvalue(c(0.05, 0.001, 0.00001, 0.99))

# With p prefix
format_pvalue(0.05, include_p = TRUE)

}
