% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.spexvb.fit.R
\name{cv.spexvb.fit}
\alias{cv.spexvb.fit}
\title{Cross-validation and Final Model Fitting for SPEVXB}
\usage{
cv.spexvb.fit(
  k = 5,
  X,
  Y,
  mu_0 = NULL,
  omega_0 = NULL,
  c_pi_0 = NULL,
  d_pi_0 = NULL,
  tau_e = NULL,
  update_order = NULL,
  mu_alpha = 1,
  tau_alpha = c(0, 10^(3:7)),
  tau_b = 400,
  standardize = TRUE,
  intercept = TRUE,
  max_iter = 100L,
  tol = 1e-05,
  seed = 12376,
  verbose = TRUE,
  parallel = TRUE
)
}
\arguments{
\item{k}{Integer, the number of folds to use for cross-validation. Must be greater than 2.}

\item{X}{A design matrix.}

\item{Y}{A response vector.}

\item{mu_0}{Initial variational mean (posterior expectation of beta_j | s_j = 1).
If NULL, initialized automatically by \code{get.initials}.}

\item{omega_0}{Initial variational probability (posterior expectation of s_j).
If NULL, initialized automatically by \code{get.initials}.}

\item{c_pi_0}{Prior parameter for pi (beta distribution shape1).
If NULL, initialized automatically by \code{get.initials}.}

\item{d_pi_0}{Prior parameter for pi (beta distribution shape2).
If NULL, initialized automatically by \code{get.initials}.}

\item{tau_e}{Initial precision of errors.
If NULL, initialized automatically by \code{get.initials}.}

\item{update_order}{A numeric vector specifying the order of updates for coefficients.
If NULL, initialized automatically by \code{get.initials}.}

\item{mu_alpha}{Mean for the prior on alpha (expansion parameter).}

\item{tau_alpha}{A numeric vector of \code{tau_alpha} values to cross-validate over.
Must have at least two values.}

\item{tau_b}{Initial precision for beta_j (when s_j = 1).}

\item{standardize}{Logical. Center Y, and center and scale X. Default is TRUE.}

\item{intercept}{Logical. Whether to include an intercept. Default is TRUE. After the model is fit on the centered and scaled data, the final coefficients are "unscaled" to put them back on the original scale of your data. The intercept is then calculated separately using the means and the final coefficients.}

\item{max_iter}{Maximum number of outer loop iterations for both CV fits and the final fit.}

\item{tol}{Convergence tolerance for both CV fits and the final fit.}

\item{seed}{Seed for reproducibility of data splitting and \code{glmnet} initials.}

\item{verbose}{Logical, if TRUE, prints progress messages during cross-validation.}

\item{parallel}{Logical, if TRUE, search in parallel.}
}
\value{
The final fitted \code{spexvb} model, which is a list containing the approximate
posterior parameters and convergence information for the full dataset using the
optimal \code{tau_alpha} determined by cross-validation.
}
\description{
This function performs k-fold cross-validation to determine the optimal
\code{tau_alpha} parameter for the \code{spexvb} model, and then fits a final \code{spexvb} model
to the full dataset using this optimal \code{tau_alpha}. Initial values for the final
model are also derived from the full dataset.
}
\details{
This function orchestrates the cross-validation process and the final model fit.
It first gets initial values for the full dataset, then uses \code{cv.spexvb} to find
the \code{tau_alpha} that minimizes cross-validation error, and finally calls \code{spexvb}
on the complete dataset with the chosen \code{tau_alpha}.
}
\examples{
\donttest{
# Generate simple synthetic data
n <- 50
p <- 100
X <- matrix(rnorm(n * p), n, p)
Y <- X[,1] * 2 + rnorm(n)

# Run cross-validation and fit final model
# (Setting k=3 to keep it quick for the example)
fit <- cv.spexvb.fit(k = 3, X = X, Y = Y)
}
}
\seealso{
\code{\link{cv.spexvb}}, \code{\link{spexvb}}
}
