% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.spexvb.R
\name{cv.spexvb}
\alias{cv.spexvb}
\title{Cross-validation for Sparse Paramaeter Expanded Variational Bayes (spexvb)}
\usage{
cv.spexvb(
  k = 5,
  X,
  Y,
  mu_0 = NULL,
  omega_0 = NULL,
  c_pi_0 = NULL,
  d_pi_0 = NULL,
  tau_e = NULL,
  update_order = NULL,
  mu_alpha = 1,
  tau_alpha = c(0, 10^(3:7)),
  tau_b = 400,
  standardize = TRUE,
  intercept = TRUE,
  max_iter = 100L,
  tol = 1e-05,
  seed = 12376,
  verbose = TRUE,
  parallel = TRUE
)
}
\arguments{
\item{k}{Integer, the number of folds for cross-validation. Must be greater than 2.}

\item{X}{A design matrix.}

\item{Y}{A response vector.}

\item{mu_0}{Initial variational mean (posterior expectation of beta_j | s_j = 1). If NULL, initialized automatically.}

\item{omega_0}{Initial variational probability (posterior expectation of s_j). If NULL, initialized automatically.}

\item{c_pi_0}{Prior parameter for pi (beta distribution shape1). If NULL, initialized automatically.}

\item{d_pi_0}{Prior parameter for pi (beta distribution shape2). If NULL, initialized automatically.}

\item{tau_e}{Initial precision of errors. If NULL, initialized automatically.}

\item{update_order}{A numeric vector specifying the order of updates for coefficients. If NULL, initialized automatically.}

\item{mu_alpha}{Mean for the prior on alpha (expansion parameter).}

\item{tau_alpha}{A numeric vector of tau_alpha values to cross-validate over. Must have at least two values.}

\item{tau_b}{Initial precision for beta_j (when s_j = 1).}

\item{standardize}{Logical. Center Y, and center and scale X. Default is TRUE.}

\item{intercept}{Logical. Whether to include an intercept. Default is TRUE. After the model is fit on the centered and scaled data, the final coefficients are "unscaled" to put them back on the original scale of your data. The intercept is then calculated separately using the means and the final coefficients.}

\item{max_iter}{Maximum number of outer loop iterations for each spexvb fit.}

\item{tol}{Convergence tolerance for each spexvb fit.}

\item{seed}{Seed for reproducibility of data splitting and \code{glmnet} initials.}

\item{verbose}{Logical, if TRUE, prints progress messages during cross-validation.}

\item{parallel}{Logical, if TRUE, search in parallel.}
}
\value{
A list containing cross-validation results:
\item{ordered_tau_alpha}{The sorted vector of tau_alpha values used.}
\item{epe_test_k}{A matrix of prediction errors (MSE) for each fold (rows) and each tau_alpha (columns).}
\item{CVE}{Cross-Validation Error (mean MSE) for each tau_alpha.}
\item{tau_alpha_opt}{The tau_alpha value that minimizes the CVE.}
}
\description{
Performs k-fold cross-validation for the spexvb model,
allowing for evaluation of model performance across different tau_alpha values.
}
\details{
This function performs k-fold cross-validation to find the optimal \code{tau_alpha}
for the \code{spexvb} model. It iterates through different \code{tau_alpha} values, trains
the model on training folds, and evaluates performance on the held-out test fold.
To leverage parallel processing, ensure a parallel backend (e.g., from \code{doParallel} or \code{doSNOW} packages)
is registered using \code{registerDoParallel()} or similar before calling this function.
}
\examples{
\donttest{
n <- 50
p <- 100
X <- matrix(rnorm(n * p), n, p)
Y <- X[,1] * 2 + rnorm(n)

# Run cross-validation only (returns errors and optimal tau_alpha)
cv_res <- cv.spexvb(k = 3, X = X, Y = Y)

# Inspect the optimal tau_alpha
print(cv_res$tau_alpha_opt)
}

}
