% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residuals_diagnostics.R
\name{plot_residuals_diagnostics}
\alias{plot_residuals_diagnostics}
\title{Plot residuals diagnostics}
\usage{
plot_residuals_diagnostics(
  model,
  point.color = viridis::viridis(100, option = "F"),
  line.color = "gray10",
  fill.color = viridis::viridis(4, option = "F", alpha = 0.95)[2],
  option = 1,
  ncol = 1,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model produced by \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}

\item{point.color}{Colors of the plotted points. Can be a single color name (e.g. "red4"), a character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F")}}

\item{line.color}{Character string, color of the line produced by \code{ggplot2::geom_smooth()}. Default: \code{"gray30"}}

\item{fill.color}{Character string, fill color of the bars produced by \code{ggplot2::geom_histogram()}. Default: \code{viridis::viridis(4, option = "F", alpha = 0.95 )[2]}}

\item{option}{(argument of \code{\link[=plot_moran]{plot_moran()}}) Integer, type of plot. If \code{1} (default) a line plot with Moran's I and p-values across distance thresholds is returned. If \code{2}, scatterplots of residuals versus lagged residuals per distance threshold and their corresponding slopes are returned. In models fitted with \code{\link[=rf_repeat]{rf_repeat()}}, the residuals and lags of the residuals are computed from the median residuals across repetitions. Option \code{2} is disabled if \code{x} is a data frame generated by \code{\link[=moran]{moran()}}.}

\item{ncol}{(argument of \code{\link[=plot_moran]{plot_moran()}}) Number of columns of the Moran's I plot if \code{option = 2}.}

\item{verbose}{Logical, if \code{TRUE}, the resulting plot is printed, Default: \code{TRUE}}
}
\value{
A patchwork object.
}
\description{
Plots normality and autocorrelation tests of model residuals.
}
\examples{

data(plants_rf)

plot_residuals_diagnostics(plants_rf)

}
\seealso{
Other visualization: 
\code{\link{plot_evaluation}()},
\code{\link{plot_importance}()},
\code{\link{plot_moran}()},
\code{\link{plot_optimization}()},
\code{\link{plot_response_curves}()},
\code{\link{plot_response_surface}()},
\code{\link{plot_training_df}()},
\code{\link{plot_training_df_moran}()},
\code{\link{plot_tuning}()}
}
\concept{visualization}
