% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mof.zdt3.R
\name{makeZDT3Function}
\alias{makeZDT3Function}
\title{ZDT3 Function}
\usage{
makeZDT3Function(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Number of decision variables.}
}
\value{
[\code{smoof_multi_objective_function}]
 Returns an instance of the ZDT3 function as a \code{smoof_multi_objective_function} object.
}
\description{
Builds and returns the two-objective ZDT3 test problem. For \eqn{m} objective it
is defined as follows
\deqn{f(\mathbf{x}) = \left(f_1(\mathbf{x}_1), f_2(\mathbf{x})\right)}
with
\deqn{f_1(\mathbf{x}_1) = \mathbf{x}_1, f_2(\mathbf{x}) = g(\mathbf{x}) h(f_1(\mathbf{x}_1), g(\mathbf{x}))}
where
\deqn{g(\mathbf{x}) = 1 + \frac{9}{m - 1} \sum_{i = 2}^m \mathbf{x}_i, h(f_1, g) = 1 - \sqrt{\frac{f_1(\mathbf{x})}{g(\mathbf{x})}} - \left(\frac{f_1(\mathbf{x})}{g(\mathbf{x})}\right)\sin(10\pi f_1(\mathbf{x}))}
and \eqn{\mathbf{x}_i \in [0,1], i = 1, \ldots, m}.
This function has some discontinuities in the Pareto-optimal front introduced
by the sine term in the \eqn{h} function (see above). The front consists of
multiple convex parts.
}
\references{
E. Zitzler, K. Deb, and L. Thiele. Comparison of Multi-objective
Evolutionary Algorithms: Empirical Results. Evolutionary Computation, 8(2):173-195, 2000
}
