% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simEventObj.R
\name{simEventObj}
\alias{simEventObj}
\title{Simulate Survival and Competing Risk Data Based on a General Model}
\usage{
simEventObj(N, obj, event_names = NULL, list_old_vars = NULL)
}
\arguments{
\item{N}{Integer. The number of individuals to simulate.}

\item{obj}{An object of class \code{simevent}. The object should have a predict2 method.
The method should return a list containing \code{chf} and \code{time}. \code{chf} should be an array
of dimension Individuals x Times x Events. The array should contain the cumulative
hazard values for each individual, at each time for each event. \code{time} should be
a vector of times where the cumulative hazard function jumps.}

\item{event_names}{A character vector. Containing the names of the various processes.
The argument is optional. By default events will be named \code{N1}, \code{N2}, ....}

\item{list_old_vars}{A named list containing the old covariates. New covariates will
be simulated by drawing from the old covariates with replacement.}
}
\value{
A \code{data.table} with one row per event per individual containing:
\itemize{
\item \code{ID} — Individual identifier.
\item \code{Time} — Event time.
\item \code{Delta} — Event type indicator.
\item Baseline covariates \code{L0}, \code{A0}.
\item Columns for each event type indicating cumulative event counts.
}
}
\description{
The \code{simEventObj} function simulates survival or competing risk data for a cohort
of individuals based on a general model with a \code{predict2} method. The function is useful
for simulating additional data under the same distribution as an original data set.
The procedure consists of fitting a model, such as a random forest or Cox Proportional
Hazards model on an original data set. Next the model is equipped with a \code{predict2} method,
and passed as an argument to the \code{simEventObj} function, which simulates new data using
the \code{predict2} method. The method should output the cumulative hazard array and the
jump times of the cumulative hazard. Simulation proceeds by sampling from the uniform
distribution and obtaining event times using the inverse of the cumulative hazard function(s).
}
\details{
The function simulates individual event histories by:
\enumerate{
\item Sampling initial baseline covariates (\code{L0}, \code{A0}) by resampling observed values.
\item Extracting cumulative hazard functions from the object.
\item Iteratively sampling event times.
\item Updating covariate histories and event counts.
\item Stopping simulation per individual after a terminal event or maximum events reached.
}
}
