% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.iifs.R
\name{plot.iifs}
\alias{plot.iifs}
\title{Method for plotting the IIFs}
\usage{
\method{plot}{iifs}(x, single_panels = TRUE, items = NULL, ...)
}
\arguments{
\item{x}{\code{data.frame} of class \code{iifs} obtained with the function \code{item_info()}}

\item{single_panels}{\code{logical}, default is \code{TRUE}. Whether to show the IIFs of each item on different panels}

\item{items}{default is \code{NULç} (shows all items). Allows for selecting specific items for the plot}

\item{...}{other arguments}
}
\value{
A ggplot
}
\description{
Plot the IIFs
}
\examples{
set.seed(123)
parameters <- data.frame(b = c(-3,-2,0, 2, 3),
a = runif(5, 1.2, 1.9),
c = rep(0,5),
e= rep(1, 5))
infos <- item_info(parameters)
plot(infos)
# plot only items 1 and 3 on a single panel
plot(infos, items = c(1,3), single_panels = FALSE)
}
