% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{[.PlinkFile}
\alias{[.PlinkFile}
\title{Read from binary PLINK file and return a genotype matrix}
\usage{
\method{[}{PlinkFile}(plinkFileObject, sampleIndex, markerIndex)
}
\arguments{
\item{plinkFileObject}{a PlinkFileObject obtained by openPlink()}

\item{sampleIndex}{integer, 1-basd, index of samples to be extracted}

\item{markerIndex}{integer, 1-basd, index of markers to be extracted}
}
\value{
genotype matrix, marker by sample
}
\description{
Read from binary PLINK file and return a genotype matrix
}
\examples{
## these indice are nonsynonymous markers for 1:196621007-196716634",
## refer to the readVCFToMatrixByRange()
fileName = system.file("plink/all.anno.filtered.extract.bed", package = "seqminer")
filePrefix = sub(fileName, pattern = ".bed", replacement = "")
plinkObj = openPlink(filePrefix)
sampleIndex = seq(3)
markerIndex =c(14, 36)
cfh <- plinkObj[sampleIndex, markerIndex]
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
