% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unidiff_Plot.R
\name{plot_uni_compare}
\alias{plot_uni_compare}
\title{plot univar data}
\usage{
plot_uni_compare(
  uni_compare_objects,
  name_dfs = NULL,
  name_benchmarks = NULL,
  summetric = NULL,
  colors = NULL,
  shapes = NULL,
  legendlabels = NULL,
  legendtitle = NULL,
  label_x = NULL,
  label_y = NULL,
  summet_size = NULL,
  summet_position = "top_right",
  point_size = NULL,
  errorbar_size = NULL,
  plot_title = NULL,
  conf_adjustment = FALSE,
  varlabels = NULL,
  ndigits = 3
)
}
\arguments{
\item{uni_compare_objects}{A object generated by the \code{\link[sampcompR]{uni_compare}}
function.}

\item{name_dfs, name_benchmarks}{A character string or vector of character
strings containing the new names of the data frames and the benchmarks, that
are used in the plot.}

\item{summetric}{If \code{"avg1"},\code{"avg2"}, \code{"mse1"},\code{"mse2"},
\code{"rmse1"},\code{"rmse2"}, or \code{"R"} the respective measure is
calculated for the biases of each survey. The values \code{"avg1"},
\code{"mse1"} and \code{"rmse1"} lead to similar results as in \code{"avg2"},
\code{"mse2"} and \code{"rmse2"}, with slightly different visualization in
the plot. If \code{summetric = "none"}, no \code{summetric} will be displayed in the
plot, and if \code{summetric = NULL} the \code{summetric} specified in the
uni_compare_object is used.}

\item{colors}{A vector of colors that is used in the plot for the
different comparisons. The color has to be specified separately for every
comparison, with one value of the vector.}

\item{shapes}{A vector of shapes applicable in \code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2()}} that is
used in the plot for the different comparisons. The shapes has to be specified
separately for every comparison, with one value of the vector.}

\item{legendlabels}{A character string or vector of strings containing a
label for the legend.}

\item{legendtitle}{A character string containing the title of the legend.}

\item{label_x, label_y}{A character string or vector of character strings
containing a label for the x-axis and y-axis.}

\item{summet_size}{A number to determine the size of the displayed
\code{summetric} in the plot.}

\item{summet_position}{A character string, to choose the position of
\code{summetric}. Can either be "top_right"(default),
"bottom_right", "bottom_left", or "top_left".}

\item{point_size}{Either NULL or a number indicating the size of the dots in
the plot. If Null by default the size is specified by ggplot.}

\item{errorbar_size}{Either NULL or a number indicating the size of the
errorbars in the plot. If Null by default the size is specified by ggplot.}

\item{plot_title}{A character string containing the title of the plot.}

\item{conf_adjustment}{If \code{conf_adjustment = TRUE} the confidence level
of the confidence interval will be
adjusted with a Bonferroni adjustment, to account for the problem of multiple
comparisons.}

\item{varlabels}{A character string or vector of character strings
containing the new names of the variables, also used in plot.}

\item{ndigits}{The number of digits to round the numbers in the plot.}
}
\value{
Plot of a \code{\link[sampcompR]{uni_compare}} object using
\code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2()}} which shows the difference between two or more data
frames.
}
\description{
\code{plot_uni_compare} This uses ggplot2 to generate a plot based on an object
generated by the \code{\link[sampcompR]{uni_compare}} function.
}
\examples{

## Get Data for comparison

data("card")

south <- card[card$south==1,]
north <- card[card$south==0,]
black <- card[card$black==1,]
white <- card[card$black==0,]

## use the function to plot the data 
univar_data<-sampcompR::uni_compare(dfs = c("north","white"),
                                    benchmarks = c("south","black"),
                                    variables= c("age","educ","fatheduc","motheduc","wage","IQ"),
                                    funct = "abs_rel_mean",
                                    nboots=0,
                                    summetric="rmse2",
                                    data=TRUE)

sampcompR::plot_uni_compare(univar_data)

}
