% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Output_Tables.R
\name{missing_table}
\alias{missing_table}
\title{Returns a Table indicating the number and proportion of NA values for a selected
set of variables.}
\usage{
missing_table(dfs, variables, df_names = NULL, varlabels = NULL)
}
\arguments{
\item{dfs}{A character vector with names of data frames for which the
missings per variable should be displayed.}

\item{variables}{A character vector of variable names for which the missings
should be displyed.}

\item{df_names}{Either Null or a character vector of names, to relabel the
data frames in the table with.}

\item{varlabels}{Either Null, or a character vector of variable names, to
relabel the variables in the table with.}
}
\value{
Returns a Table indicating the number and proportion of NA values for
a selected set of variables. This can be used to get an overview of the data,
detect errors after data rangeling, or find items in a survey, with especially,
high item nonresponse.
}
\description{
Returns a Table indicating the number and proportion of NA values for a selected
set of variables.
}
\examples{
## Get Data for comparison

data("card")

north <- card[card$south==0,]
white <- card[card$black==0,]

variables<- c("age","educ","fatheduc","motheduc","wage","IQ")
varlabels<-c("Age","Education","Father's Education",
             "Mother's Education","Wage","IQ")

missing_tab<-sampcompR::missing_table(dfs = c("north","white"),
                                      variables=variables,
                                      df_names = c("North","White"),
                                      varlabels=varlabels)

missing_tab



}
