% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{outliers_variables}
\alias{outliers_variables}
\alias{ao_variable}
\alias{tc_variable}
\alias{ls_variable}
\alias{so_variable}
\title{Generating Outlier regressors}
\usage{
ao_variable(frequency, start, length, s, pos, date = NULL)

tc_variable(frequency, start, length, s, pos, date = NULL, rate = 0.7)

ls_variable(frequency, start, length, s, pos, date = NULL, zeroended = TRUE)

so_variable(frequency, start, length, s, pos, date = NULL, zeroended = TRUE)
}
\arguments{
\item{frequency}{Frequency of the series, number of periods per year
(12, 4, 3, 2...)}

\item{start, length}{First date (array with the first year and the first
period, for instance \code{c(1980, 1)}) and number of periods of the output
variables. Can also be provided with the \code{s} argument}

\item{s}{time series used to get the dates for the trading days variables.
If supplied the parameters \code{frequency}, \code{start} and \code{length} are ignored.}

\item{pos, date}{the date of the outlier, defined by the position in period
compared to the first date (\code{pos} parameter) or by a specific
\code{date} defined in the format \code{"YYYY-MM-DD"}.}

\item{rate}{the decay rate of the transitory change regressor (see details).}

\item{zeroended}{Boolean indicating if the regressor should end by 0
(\code{zeroended = TRUE}, default) or 1 (\code{zeroended = FALSE}), argument
valid only for LS and SO.}
}
\value{
a \code{ts} object
}
\description{
Generating Outlier regressors
}
\details{
An additive outlier (AO, \code{ao_variable}) is defined as:
\deqn{AO_t = \begin{cases}1 &\text{if } t=t_0 \\
 0 & \text{if }t\ne t_0\end{cases}}

A level shift (LS, \code{ls_variable}) is defined as (if \code{zeroended = TRUE}):
\deqn{LS_t = \begin{cases}-1 &\text{if } t < t_0 \\
 0 & \text{if }t\geq t_0 \end{cases}}
A transitory change (TC, \code{tc_variable}) is defined as:
\deqn{TC_t = \begin{cases} 0 &\text{if }t < t_0 \\
\alpha^{t-t_0} & t\geq t_0 \end{cases}}
A seasonal outlier (SO, \code{so_variable}) is defined as (if \code{zeroended = TRUE}):
\deqn{SO_t = \begin{cases} 0 &\text{if }t\geq t_0 \\
-1 & \text{if }t < t_0 \text{ and $t$ same periode as }t_0\\
 -\frac{1}{s-1} & \text{otherwise }\end{cases}}
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Outliers in February 2002
ao <- ao_variable(12, c(2000, 1), length = 12 * 4, date = "2002-02-01")
ls <- ls_variable(12, c(2000, 1), length = 12 * 4, date = "2002-02-01")
tc <- tc_variable(12, c(2000, 1), length = 12 * 4, date = "2002-02-01")
so <- so_variable(12, c(2000, 1), length = 12 * 4, date = "2002-02-01")
plot.ts(ts.union(ao, ls, tc, so),
    plot.type = "single",
    col = c("black", "orange", "green", "gray")
)
\dontshow{\}) # examplesIf}
}
