% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pScore.R
\name{pScore}
\alias{pScore}
\title{Transform p-values to continuous scores}
\usage{
pScore(p, sign = 1, method = c("qnorm", "absLog10"), replaceZero = TRUE)
}
\arguments{
\item{p}{\emph{p}-value between (0,1]}

\item{sign}{Sign of the score, either positive (in case of positive
numbers), negative (in case of negative numbers), or zero.  In case a
logical vector, \code{TRUE} is interpreted as positive and \code{FALSE} is
interpreted as negative.}

\item{method}{Currently available methods include \code{qnorm} and \code{absLog10}.}

\item{replaceZero}{Logical, whether to replace zero p-values with the 
minimal double value specified by the machine. Default is \code{TRUE}. If 
set to \code{FALSE}, results will contain infinite values.}
}
\value{
A numeric vector of transformed p-values using the specified method.
}
\description{
The function wraps other functions to map \emph{p} values ranging on \eqn{(0,1]}
to continuous scores ranging on \eqn{R} in a number of ways.
}
\examples{

testPvals <- c(0.001, 0.01, 0.05, 0.1, 0.5, 1)
pScore(testPvals, method="absLog10")
pScore(testPvals, method="qnorm")
testPvalSign <- rep(c(-1,1), 3)
pScore(testPvals, sign=testPvalSign, method="absLog10")
pScore(testPvals, sign=testPvalSign, method="qnorm")
testLog <- rep(c(TRUE, FALSE),3)
pScore(testPvals, testLog, method="absLog10")
pScore(testPvals, testLog, method="qnorm")

testPvals <- 10^seq(-5, 0, 0.05)
plot(pScore(testPvals, method="qnorm"),
     pScore(testPvals, method="absLog10"),
     xlab="pQnormScore", ylab="pAbsLog10Score"); abline(0,1, col="red", lty=2)
}
\seealso{
\code{\link{pAbsLog10Score}}, \code{\link{pQnormScore}}
}
