% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaPlots.R
\name{pcaRotation}
\alias{pcaRotation}
\title{Retrieve PCA rotations from prcomp objects}
\usage{
pcaRotation(x, choices, offset, reverse = c(FALSE, FALSE))
}
\arguments{
\item{x}{An object of prcomp}

\item{choices}{Integer vector, indices of principal components, default the
first two PCs. If missing, \code{NULL} or \code{NA}, all PCs are returned.}

\item{offset}{Oither one or more rows's names in the rotation matrix, or
indices, or a logical vector. The average of the rows specified by
offset is set to zero.}

\item{reverse}{Logical of the same length as \code{choices} or 1 (which will be repeated),
indicating whether the sign of values in the indexed axis should be reversed}
}
\description{
Retrieve PCA rotations from prcomp objects
}
\examples{

testMatrix <- matrix(rnorm(1000), nrow=10)
testPCA <- prcomp(testMatrix)
testPCAscores <- pcaScores(testPCA)

testPCAscores.withOffset <- pcaScores(testPCA, offset=c(1,3,5))
## notice the average of offset-rows are near zero
colMeans(as.matrix(testPCAscores.withOffset)[c(1,3,5),])

testPCAscores.withReverse <- pcaScores(testPCA, reverse=c(TRUE, FALSE))
colMeans(as.matrix(testPCAscores.withReverse)[c(1,3,5),])

}
