% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{colKappa}
\alias{colKappa}
\title{Calculate column-wise kappa statistics of a matrix}
\usage{
colKappa(matrix, minOverlap = 0L)
}
\arguments{
\item{matrix}{An adjacency matrix, containing values of either 0 or 1 (default), or values between 0 and 1 (weighted).}

\item{minOverlap}{Integer, minimal overlap between two columns in order to be considered. Pairs with fewer overlaps will return \code{NA}.}
}
\value{
A matrix of size \eqn{n \times n} if the input matrix is of size \eqn{m \times n}.
}
\description{
The function returns column-wise kappa statistics of a matrix, using a linear algebra procedure implemented in C++.
}
\note{
A kappa statistics of value 1 indicates perfect agreement. A value of 0
indicates no agreement. Note that the value can be negative, which implies
the agreement is worse than random.
}
\examples{
testMat <- cbind(c(1,1,0,0,1,0), c(1,1,0,1,1,0))
colKappa(testMat)

}
\seealso{
\code{\link{rowKappa}} to calculate the statistic of rows

Other kappa functions: 
\code{\link{kappaSimp}()},
\code{\link{rowKappa}()}
}
\concept{kappa functions}
