% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcessTo.R
\name{keepOrigGeom}
\alias{keepOrigGeom}
\title{Keep original geometries of \code{sf} objects}
\usage{
keepOrigGeom(newObj, origObj)
}
\arguments{
\item{newObj}{The new, derived \code{sf} object}

\item{origObj}{The previous, object whose geometries should be used.}
}
\value{
The original \code{newObj}, but with only the type of geometry that entered
into the function.
}
\description{
When intersections occur, what was originally 2 polygons features can become
\code{LINESTRING} and/or \code{POINT} and any \code{COLLECTIONS} or \verb{MULTI-} versions of these.
This function evaluates what the original geometry was and drops any newly created
\emph{different} geometries. For example, if a \code{POLYGON} becomes a \code{COLLECTION} of
\code{MULTIPOLYGON}, \code{POLYGON} and \code{POINT} geometries, the \code{POINT} geometries will
be dropped. This function is used internally in \code{\link[=postProcessTo]{postProcessTo()}}.
}
