% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_pairwise_haplen.R
\name{calc_pairwise_haplen}
\alias{calc_pairwise_haplen}
\title{Calculate pairwise shared haplotype length between all chromosomes}
\usage{
calc_pairwise_haplen(
  haplohh,
  mrk,
  phased = TRUE,
  maxgap = NA,
  max_extend = NA,
  side = "both"
)
}
\arguments{
\item{haplohh}{an object of class \code{haplohh} (see \code{\link{data2haplohh}}).}

\item{mrk}{integer representing the number of the focal marker within the haplohh object
or string representing its ID/name.}

\item{phased}{logical. If \code{TRUE} (default) chromosomes are expected to be phased. If \code{FALSE}, the haplotype data is assumed to
consist of pairwise ordered chromosomes belonging to diploid individuals and only the two chromosomes of
each individual are compared.}

\item{maxgap}{maximum allowed gap in bp between two markers. If exceeded, further calculation is stopped at the gap
(default=\code{NA}, i.e. no limitation).}

\item{max_extend}{maximum distance in bp to extend shared haplotypes away from the focal marker.
(default \code{NA}, i.e. no limitation).}

\item{side}{side to consider, either "left" (positions lower than focal position), "right" (positions higher than focal position)
or "both" (default).}
}
\value{
The returned value is a matrix with pairwise shared haplotype lengths.
}
\description{
Calculate pairwise shared haplotype length between all chromosomes at a focal marker.
}
\details{
The function computes the length of shared haplotypes (stretches of identical sequence) around
the focal marker.

Note that the function \code{\link{calc_haplen}} calculates for each chromosome
the boundaries of its longest shared haplotype; separately upstream and downstream of
the focal marker.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#computing shared haplotype lengths around the marker "F1205400"
#which displays a strong signal of selection
m <- calc_pairwise_haplen(haplohh_cgu_bta12, mrk = "F1205400")
#note that calc_haplen() returns the length of the longest shared haplotype:
f <- calc_furcation(haplohh_cgu_bta12, mrk = "F1205400")
h <- calc_haplen(f)
#all pairwise shared haplotype lengths to the left of the focal marker
m_left <- calc_pairwise_haplen(haplohh_cgu_bta12, mrk = "F1205400", side = "left")
#get for each chromosome the maximum shared haplotype length
max_left <- apply(m_left, 1, max)
all.equal(max_left, h$position - h$haplen$MIN, check.attributes = FALSE)
#the same for shared haplotypes to the right of the focal marker
m_right <- calc_pairwise_haplen(haplohh_cgu_bta12, mrk = "F1205400", side = "right")
max_right <- apply(m_right, 1, max)
all.equal(max_right, h$haplen$MAX - h$position, check.attributes = FALSE)
}
\seealso{
\code{\link{calc_haplen}}, \code{\link{data2haplohh}}, \code{\link{scan_hh_full}}.
}
