% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsr_payment_summary.R
\name{hsr_payment_summary}
\alias{hsr_payment_summary}
\alias{hsr_count_dual_stays}
\alias{hsr_count_total_stays}
\alias{hsr_dual_proportion}
\alias{hsr_peer_group}
\alias{hsr_neutrality_modifier}
\alias{hsr_payment_adjustment_factor}
\alias{hsr_payment_penalty}
\title{Extract payment summary information from a Hospital-Specific Report (HSR)}
\usage{
hsr_payment_summary(file)

hsr_count_dual_stays(file)

hsr_count_total_stays(file)

hsr_dual_proportion(file)

hsr_peer_group(file)

hsr_neutrality_modifier(file)

hsr_payment_adjustment_factor(file)

hsr_payment_penalty(file)
}
\arguments{
\item{file}{File path to a report. For convenience functions, this can also be the pre-parsed table from \code{hsr_extract_payment_summary()} (to minimize file I/O).}
}
\value{
\itemize{
\item \code{hsr_payment_summary()} returns a \code{\link[tibble:tibble]{tibble::tibble()}} containing the full Table 1 parsed from the report.
\item Additional convenience functions extract specific columns from this table, and always return a numeric value.
}
}
\description{
Parses the Table 1 payment summary from the HSR, including (but not limited to) the payment penalty,
peer group the hospital was compared against, and dual proportion that determines peer group assignment.

\emph{\strong{Note}: CMS changed the format of Hospital-Specific Reports (HSRs) for FY2026 (see \href{https://qualitynet.cms.gov/inpatient/hrrp/reports#tab2}{here}). The current HSR functions support formats through FY2025.}
}
\examples{
# Access a report
my_report <- hsr_mock_reports("FY2025_HRRP_MockHSR.xlsx")

# Full payment summary table
payment_summary <- hsr_payment_summary(my_report)
payment_summary


# Extract individual components (from file)
hsr_payment_penalty(my_report)

# Or existing extract
hsr_payment_penalty(payment_summary)
}
