% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_rot.R
\name{rdd_bw_rsw}
\alias{rdd_bw_rsw}
\title{Global bandwidth selector of Ruppert, Sheather and Wand (1995) from package \pkg{KernSmooth}}
\usage{
rdd_bw_rsw(object, type = c("global", "sided"))
}
\arguments{
\item{object}{object of class rdd_data created by \code{\link{rdd_data}}}

\item{type}{Whether to choose a global bandwidth for the whole function (\code{global}) 
or for each side (\code{sided})}
}
\value{
One (or two for \code{sided}) bandwidth value.
}
\description{
Uses the global bandwidth selector of Ruppert, Sheather and Wand (1995) 
either to the whole function, or to the functions below and above the cutpoint.
}
\examples{
data(house)
rd<- rdd_data(x=house$x, y=house$y, cutpoint=0)
rdd_bw_rsw(rd)
}
\references{
See \code{\link[KernSmooth]{dpill}}
}
\seealso{
\code{\link{rdd_bw_ik}} Local RDD bandwidth selector using the plug-in method of Imbens and Kalyanaraman (2012)
}
